/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2013, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.extension.picketlink.idm;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

/**
 * @author <a href="mailto:psilva@redhat.com">Pedro Silva</a>
 */
public class IDMSubsystemAdd extends AbstractAddStepHandler {
    private static final String JAVA_VERSION = WildFlySecurityManager.getPropertyPrivileged("java.vm.specification.version", null);
    private static final int MIN_UNSUPPORTED_JAVA_VERSION = 14;

    public static final IDMSubsystemAdd INSTANCE = new IDMSubsystemAdd();

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        int javaVersion = JAVA_VERSION.startsWith("1.") ? Integer.parseInt(JAVA_VERSION.substring(2, 3)) : Integer.parseInt(JAVA_VERSION);
        if (javaVersion >= MIN_UNSUPPORTED_JAVA_VERSION) {
            throw PicketLinkLogger.ROOT_LOGGER.unsupportedResourceSinceJavaVersion(context.getCurrentAddressValue(), MIN_UNSUPPORTED_JAVA_VERSION);
        }

        PicketLinkLogger.ROOT_LOGGER.activatingSubsystem("Identity Management");
    }
}
