package org.jboss.installer.validators;

import org.jboss.installer.core.ValidationResult;
import org.junit.Test;

import static org.junit.Assert.*;

public class CombiningValidatorTest {

    @Test
    public void singleValidator_ReturnsResult() {
        assertEquals(ValidationResult.ok(), CombiningValidator.of(()-> ValidationResult.ok()).validate());

        assertEquals(ValidationResult.warning("warning"), CombiningValidator.of(()-> ValidationResult.warning("warning")).validate());

        assertEquals(ValidationResult.error("error"), CombiningValidator.of(()-> ValidationResult.error("error")).validate());
    }

    @Test
    public void twoValidators_BothOK_ReturnsOK() {
        assertEquals(ValidationResult.ok(), CombiningValidator.of(()-> ValidationResult.ok(), ()-> ValidationResult.ok()).validate());
    }

    @Test
    public void twoValidators_FirstFails_ReturnsError() {
        assertEquals(ValidationResult.error("error1"), CombiningValidator.of(()-> ValidationResult.error("error1"), ()-> ValidationResult.ok()).validate());
    }

    @Test
    public void twoValidators_BothFail_ReturnsFirstError() {
        assertEquals(ValidationResult.error("error1"), CombiningValidator.of(
                ()-> ValidationResult.error("error1"), ()-> ValidationResult.error("error2"))
                .validate());
    }

    @Test
    public void twoValidators_SecondFail_ReturnsSecondError() {
        assertEquals(ValidationResult.error("error2"), CombiningValidator.of(
                        ()-> ValidationResult.ok(), ()-> ValidationResult.error("error2"))
                .validate());
    }

    @Test
    public void twoValidators_FirstWarningSecondOk_ReturnsWarning() {
        assertEquals(ValidationResult.warning("warning1"), CombiningValidator.of(
                        ()-> ValidationResult.warning("warning1"), ()-> ValidationResult.ok())
                .validate());
    }

    @Test
    public void twoValidators_FirstWarningSecondError_ReturnsError() {
        assertEquals(ValidationResult.error("error2"), CombiningValidator.of(
                        ()-> ValidationResult.warning("warning1"), ()-> ValidationResult.error("error2"))
                .validate());
    }

    @Test
    public void twoValidators_TwoWarning_ReturnsFirstWarning() {
        assertEquals(ValidationResult.warning("warning1"), CombiningValidator.of(
                        ()-> ValidationResult.warning("warning1"), ()-> ValidationResult.warning("warning2"))
                .validate());
    }
}