#!/bin/bash -ex

readonly PROPOSED_MANIFEST_URL_BASE="https://gitlab.cee.redhat.com/jboss-set/proposed-manifests"

echo "Downloading current manifests"
curl "${PROPOSED_MANIFEST_URL_BASE}/jboss-eap-8.0-proposed-manifests/-/raw/main/manifest.yaml" -o eap8-manifest.yaml
curl "${PROPOSED_MANIFEST_URL_BASE}/installation-manager-8.0-proposed-manifests/-/raw/1.0.x/manifest.yaml" -o prospero-manifest.yaml

echo "Alligning dependnecies"
mvn org.wildfly:wildfly-channel-maven-plugin:upgrade -DmanifestFile=eap8-manifest.yaml
mvn org.wildfly:wildfly-channel-maven-plugin:upgrade -DmanifestFile=prospero-manifest.yaml

echo "Clean up"
if [ -f eap8-manifest.yaml ]; then
  rm eap8-manifest.yaml
fi


if [ -f prosposed-manifest.yaml ]; then
  rm proposed-manifest.yaml
fi

git diff
