/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.auto;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

class ConfigElementXmlEventReader implements XMLEventReader {

    private final XMLEventReader reader;

    ConfigElementXmlEventReader(XMLEventReader reader) {
        this.reader = reader;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        return reader.nextEvent();
    }

    @Override
    public boolean hasNext() {
        if (!reader.hasNext()) {
            return false;
        }

        try {
            final XMLEvent next = reader.peek();
            if (next.isEndElement() && next.asEndElement().getName().getLocalPart().equals(InstallationDataSerializer.POST_INSTALL_CONFIG_TAG)) {
                return false;
            }
        } catch (XMLStreamException e) {
            throw new RuntimeException("Unexpected end of file", e);
        }

        return true;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return reader.getElementText();
    }

    @Override
    public Object next() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws XMLStreamException {

    }
}
