package org.jboss.installer.core;

import org.jboss.installer.actions.InstallerAction;
import org.jboss.installer.navigation.NavigationState;

/**
 * Executes an {@link InstallerAction} in a separate thread. Only a single action can be executed at any time.
 * Blocks {@link NavigationState} during the execution and unblocks it only if the action was completed successfully.
 */
public interface ActionExecutor {
    /**
     * attempts to execute {@code action}.
     *
     * @throws IllegalStateException - if an action is already being executed
     * @param action
     * @param navState
     */
    void execute(InstallerAction action, NavigationState navState);

    /**
     * stops current action if one is being executed.
     */
    void stopCurrentAction();
}
