/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.screens;

import org.jboss.installer.core.InstallationData;
import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.Screen;
import org.jboss.installer.core.ScreenManager;
import org.jboss.installer.postinstall.task.AbstractHttpsEnableTask;
import org.jboss.installer.postinstall.task.HttpsEnableTask;
import org.jboss.installer.postinstall.task.JBossCliPortUpdaterTask;

import java.util.Set;

public class SSLSecurityScreen extends AbstractSSLSecurityScreen {

    public static final String NAME = "SSLSecurityScreen";
    public static final String TITLE_KEY = "ssl_security.title";
    public static final String DESCRIPTION_KEY = "ssl.config.description";

    private final HttpsEnableTask task = new HttpsEnableTask();
    private final JBossCliPortUpdaterTask cliPortUpdaterTask = new JBossCliPortUpdaterTask();

    public SSLSecurityScreen(Screen parent, LanguageUtils langUtils, boolean isActive) {
        super(parent, langUtils, isActive, DESCRIPTION_KEY, true);
    }

    @Override
    public String getTitle() {
        return langUtils.getString(TITLE_KEY);
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected AbstractHttpsEnableTask createTask() {
        return task;
    }

    protected AbstractHttpsEnableTask.Config createConfig(Set<String> protocols, String cipherSuites, String tls13cipherNames,
                                                          String keyStorePath, String keyStorePassword, boolean mutual, String trustStorePath, String trustStorePassword,
                                                          boolean doGenerateStore, String dn, String validity, String clientCertPath, boolean validateCertificate) {

        return new HttpsEnableTask.Config(protocols, cipherSuites, tls13cipherNames, keyStorePath, keyStorePassword, mutual,
                trustStorePath, trustStorePassword, doGenerateStore, dn, validity, clientCertPath, validateCertificate);
    }

    @Override
    protected Class<? extends AbstractHttpsEnableTask.Config> getConfigClass() {
        return HttpsEnableTask.Config.class;
    }

    @Override
    public void record(InstallationData installationData, ScreenManager screenManager) {
        super.record(installationData, screenManager);
        installationData.addPostInstallTask(cliPortUpdaterTask);
    }

    @Override
    public void rollback(InstallationData installationData) {
        super.rollback(installationData);
        installationData.removePostInstallTask(cliPortUpdaterTask);
    }
}
