package org.jboss.installer.screens.jsf;

import org.jboss.installer.common.FileChooserPanel;
import org.jboss.installer.common.UiResources;
import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.MnemonicUtils;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.nio.file.Path;

import static javax.swing.JFileChooser.FILES_ONLY;
import static org.jboss.installer.screens.DefaultScreen.DESCRIPTION_INSET;
import static org.jboss.installer.screens.DefaultScreen.FIELD_ROW_INSET;
import static org.jboss.installer.screens.JSFInstallScreen.FULL_COLUMN_WIDTH;
import static org.jboss.installer.screens.JSFInstallScreen.JSF_INSTALL_JSFIMPL_KEY;

public class DownloadArtifactsPanel extends JPanel {

    private final FileChooserPanel implFileChooser;

    public DownloadArtifactsPanel(LanguageUtils langUtils, MnemonicUtils mnemonicUtils, Path targetFolder) {
        super(new GridBagLayout());

        this.implFileChooser = FileChooserPanel.builder(langUtils, FILES_ONLY, mnemonicUtils).fileFilter(new FileNameExtensionFilter("JAR (.jar)", "jar")).build();

        final GridBagConstraints c = UiResources.initializeConstraints();
        c.gridwidth = FULL_COLUMN_WIDTH;
        c.insets = DESCRIPTION_INSET;
        this.add(UiResources.createFieldLabel("Use provided Mojarra jars to configure JBoss EAP."), c);

        c.gridy++;
        c.gridwidth = FULL_COLUMN_WIDTH;
        c.insets = FIELD_ROW_INSET;
        this.add(UiResources.createFieldLabel(langUtils.getString(JSF_INSTALL_JSFIMPL_KEY)), c);
        c.gridy++;

        this.add(implFileChooser, c);
        c.gridy++;

        c.gridy++;
        c.gridx = 0;
        c.gridwidth = 3;
        final JLabel channelTargetPathLabel = UiResources.createFieldLabel("Channel target path");
        this.add(channelTargetPathLabel, c);
        channelTargetPathLabel.setVisible(false);
    }


    public JComponent getDefaultFocusComponent() {
        return implFileChooser;
    }

    public String getImplFileValue() throws FileChooserPanel.InvalidPathException {
        return implFileChooser.asPathOrUrl();
    }
}
