package org.jboss.installer.auto;

import org.jboss.installer.postinstall.task.LoggingLevelsTask;
import org.junit.Test;
import org.w3c.dom.Document;

import static org.junit.Assert.assertEquals;

public class InstallationWithLoggingLevelTest extends BaseAutomaticInstallationTest {

    @Test
    public void testInstallationWithLoggingLevel() throws Exception {
        installationData.addPostInstallTask(new LoggingLevelsTask());
        installationData.putConfig(new LoggingLevelsTask.Config("DEBUG", "TRACE"));

        automaticInstallation.performInstallation(installationData);

        Document doc = builder.parse(testDir.resolve("standalone").resolve("configuration").resolve("standalone.xml").toFile());
        assertEquals("DEBUG", getLevel(doc, "//root-logger/level"));
    }
}
