package org.jboss.installer.core;

import org.jboss.installer.postinstall.task.PortConfigurationTask;
import org.junit.Assert;
import org.junit.Test;

import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import static org.jboss.installer.screens.CustomPortConfigurationScreen.AJP_KEY;
import static org.jboss.installer.screens.CustomPortConfigurationScreen.JGROUPS_MPING_ADDRESS_KEY;
import static org.jboss.installer.screens.CustomPortConfigurationScreen.JGROUPS_MPING_MCAST_PORT_KEY;
import static org.jboss.installer.screens.CustomPortConfigurationScreen.JGROUPS_UDP_ADDRESS_KEY;
import static org.jboss.installer.screens.CustomPortConfigurationScreen.JGROUPS_UDP_KEY;
import static org.jboss.installer.screens.CustomPortConfigurationScreen.JGROUPS_UDP_MCAST_PORT_KEY;
import static org.jboss.installer.screens.CustomPortConfigurationScreen.MODCLUSTER_ADDRESS_KEY;
import static org.jboss.installer.screens.CustomPortConfigurationScreen.MODCLUSTER_MCAST_PORT_KEY;

public class SocketBindingUtilsTest {

    public static final List<String> AJP_PROPERTY = Collections.singletonList(AJP_KEY);
    public static final List<String> UDP_PROPERTY = Collections.singletonList(JGROUPS_UDP_KEY);
    public static final List<String> MPING_PROPERTY = Collections.singletonList(JGROUPS_MPING_MCAST_PORT_KEY);
    public static final List<String> MODCLUSTER_PROPERTY = Collections.singletonList(MODCLUSTER_MCAST_PORT_KEY);
    public static final String PORT_VALUE = "1234";
    public static final String IP_ADDRESS_VALUE = "11.22.33.44";
    public static final String DEFAULT_PROPERTY = "default.property.name";
    HashMap<String, JTextField> systemPropertyFieldMap = initSystemPropertyFieldMap();
    HashMap<String, JTextField> ipAddressFieldMap = initIpAddressFieldMap();
    HashMap<String, JFormattedTextField> portFieldMap = initPortFieldMap();
    SocketBindingUtils utils = new SocketBindingUtils(systemPropertyFieldMap, ipAddressFieldMap, portFieldMap);

    @Test
    public void createPortSocketBindingTest() {
        PortConfigurationTask.SocketBinding baseSocketBinding = new PortConfigurationTask.SocketBinding
                ("ajp", DEFAULT_PROPERTY, Integer.parseInt(PORT_VALUE));
        PortConfigurationTask.SocketBinding testedSocketBinding = utils.createPortSocketBinding(AJP_KEY);
        compareSocketBindings(baseSocketBinding, testedSocketBinding);
    }

    @Test
    public void createModclusterSocketBindingTest() {
        PortConfigurationTask.SocketBinding baseSocketBinding = new PortConfigurationTask.SocketBinding
                ("modcluster", DEFAULT_PROPERTY, IP_ADDRESS_VALUE, Integer.parseInt(PORT_VALUE), null);
        PortConfigurationTask.SocketBinding testedSocketBinding = utils.createModclusterSocketBinding();
        compareSocketBindings(baseSocketBinding, testedSocketBinding);
    }

    @Test
    public void createMpingSocketBindingTest() {
        PortConfigurationTask.SocketBinding baseSocketBinding = new PortConfigurationTask.SocketBinding
                ("jgroups-mping", DEFAULT_PROPERTY, IP_ADDRESS_VALUE, Integer.parseInt(PORT_VALUE), null);
        PortConfigurationTask.SocketBinding testedSocketBinding = utils.createMpingSocketBinding();
        compareSocketBindings(baseSocketBinding, testedSocketBinding);
    }

    @Test
    public void createUdpSocketBindingTest() {
        PortConfigurationTask.SocketBinding baseSocketBinding = new PortConfigurationTask.SocketBinding
                ("jgroups-udp", DEFAULT_PROPERTY, IP_ADDRESS_VALUE, Integer.parseInt(PORT_VALUE), Integer.parseInt(PORT_VALUE));
        PortConfigurationTask.SocketBinding testedSocketBinding = utils.createUdpSocketBinding();
        compareSocketBindings(baseSocketBinding, testedSocketBinding);
    }

    @Test
    public void createSocketBindingsTest() {
        compareSocketBindings(utils.createPortSocketBinding(AJP_KEY), utils.createSocketBindings(AJP_PROPERTY).get(0));
        compareSocketBindings(utils.createUdpSocketBinding(), utils.createSocketBindings(UDP_PROPERTY).get(0));
        compareSocketBindings(utils.createMpingSocketBinding(), utils.createSocketBindings(MPING_PROPERTY).get(0));
        compareSocketBindings(utils.createModclusterSocketBinding(), utils.createSocketBindings(MODCLUSTER_PROPERTY).get(0));

    }

    private HashMap<String, JTextField> initSystemPropertyFieldMap() {
        HashMap<String, JTextField> hashMap = new HashMap<>();
        hashMap.put(AJP_KEY, new JTextField(DEFAULT_PROPERTY));
        hashMap.put(JGROUPS_MPING_ADDRESS_KEY, new JTextField(DEFAULT_PROPERTY));
        hashMap.put(JGROUPS_UDP_ADDRESS_KEY, new JTextField(DEFAULT_PROPERTY));
        hashMap.put(MODCLUSTER_ADDRESS_KEY, new JTextField(DEFAULT_PROPERTY));
        return hashMap;
    }

    private HashMap<String, JFormattedTextField> initPortFieldMap() {
        HashMap<String, JFormattedTextField> hashMap = new HashMap<>();
        hashMap.put(AJP_KEY, new JFormattedTextField(PORT_VALUE));
        hashMap.put(JGROUPS_MPING_MCAST_PORT_KEY, new JFormattedTextField(PORT_VALUE));
        hashMap.put(JGROUPS_UDP_MCAST_PORT_KEY, new JFormattedTextField(PORT_VALUE));
        hashMap.put(JGROUPS_UDP_KEY, new JFormattedTextField(PORT_VALUE));
        hashMap.put(MODCLUSTER_MCAST_PORT_KEY, new JFormattedTextField(PORT_VALUE));
        return hashMap;
    }

    private HashMap<String, JTextField> initIpAddressFieldMap() {
        HashMap<String, JTextField> hashMap = new HashMap<>();
        hashMap.put(JGROUPS_MPING_ADDRESS_KEY, new JTextField(IP_ADDRESS_VALUE));
        hashMap.put(JGROUPS_UDP_ADDRESS_KEY, new JTextField(IP_ADDRESS_VALUE));
        hashMap.put(MODCLUSTER_ADDRESS_KEY, new JTextField(IP_ADDRESS_VALUE));
        return hashMap;
    }

    private void compareSocketBindings(PortConfigurationTask.SocketBinding baseSocketBinding, PortConfigurationTask.SocketBinding testedSocketBinding) {
        Assert.assertEquals(baseSocketBinding.getKey(), testedSocketBinding.getKey());
        Assert.assertEquals(baseSocketBinding.getProperty(), testedSocketBinding.getProperty());
        Assert.assertEquals(baseSocketBinding.getPortValue(), testedSocketBinding.getPortValue());
        Assert.assertEquals(baseSocketBinding.getMcastAddress(), testedSocketBinding.getMcastAddress());
        Assert.assertEquals(baseSocketBinding.getMcastPort(), testedSocketBinding.getMcastPort());
    }
}
