package org.jboss.installer.postinstall.task;

import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.i18n.DefaultLanguageUtils;
import org.jboss.installer.postinstall.TaskPrinter;

import java.util.Locale;

public class NoopPrinter extends TaskPrinter {

    private final LanguageUtils langUtils;

    public NoopPrinter() {
        super(null, null);
        this.langUtils = DefaultLanguageUtils.builder().setLocale(Locale.ENGLISH).build();
    }

    @Override
    public void print(Exception ex) {
        ex.printStackTrace();
    }

    @Override
    public void print(String msgKey, String... params) {
        // check the string can be retrieved
        System.out.println(langUtils.getString(msgKey, params));
    }
}
