package org.jboss.installer.screens.jsf;

import org.jboss.installer.common.UiResources;

import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;

class ChannelOptionsPanel extends JPanel {
    private final JRadioButton createChannelOption;
    private final JRadioButton existingChannelOption;

    public ChannelOptionsPanel() {
        super(new GridBagLayout());
        final GridBagConstraints c = UiResources.initializeConstraints();
        final ButtonGroup channelSelector = new ButtonGroup();
        createChannelOption = UiResources.createRadioButton("Create JSF channel", true);
        channelSelector.add(createChannelOption);
        existingChannelOption = UiResources.createRadioButton("Existing JSF channel", false);
        channelSelector.add(existingChannelOption);
        c.gridy = 0;
        c.gridx = 0;
        this.add(createChannelOption, c);
        c.gridx++;
        this.add(existingChannelOption, c);
        c.gridx++;
        this.add(Box.createHorizontalBox(), c);
    }

    public void registerSwitch(JPanel createChannelPanel, JPanel existingChannelPanel) {
        final ActionListener switchPanels = e -> {
            if (createChannelOption.isSelected()) {
                createChannelPanel.setVisible(true);
                existingChannelPanel.setVisible(false);
            } else if (existingChannelOption.isSelected()) {
                existingChannelPanel.setVisible(true);
                createChannelPanel.setVisible(false);
            }
        };
        createChannelOption.addActionListener(switchPanels);
        existingChannelOption.addActionListener(switchPanels);
    }

    public Options getSelected() {
        if (existingChannelOption.isSelected()) {
            return Options.EXISTING_CHANNEL;
        } else if (createChannelOption.isSelected()) {
            return Options.CREATE_CHANNEL;
        } else {
            throw new RuntimeException("No options are selected");
        }
    }

    public enum Options {CREATE_CHANNEL, EXISTING_CHANNEL}
}
