/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.auto;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import java.nio.file.Path;

import org.apache.commons.io.FileUtils;
import org.jboss.installer.core.InstallationData;
import org.jboss.installer.postinstall.task.AddAdminUserTask;
import org.jboss.installer.test.utils.MockLanguageUtils;
import org.jboss.installer.test.utils.TestProperties;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class BaseAutomaticInstallationTest {

   protected Path testDir;
   private XPath xPath =  XPathFactory.newInstance().newXPath();
   private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
   protected DocumentBuilder builder;
   protected AutomaticInstallation automaticInstallation = new AutomaticInstallation(new MockLanguageUtils());
   protected InstallationData installationData;

   @Rule
   public final TemporaryFolder tempDir = new TemporaryFolder();

   @Before
   public void setUp() throws Exception {
      testDir = tempDir.newFolder().toPath();

      builder = factory.newDocumentBuilder();
      installationData = defaultInstallationData();
   }

   @After
   public void tearDown() throws Exception {
      FileUtils.deleteQuietly(testDir.toFile());
   }

   private InstallationData defaultInstallationData() {
      final InstallationData installationData = new InstallationData();
      installationData.setAdminUsername("testName");
      installationData.setPassword("testPassword");
      installationData.setTargetFolder(testDir.toAbsolutePath());
      installationData.setMavenRepositories(TestProperties.getTestRepositories());
      installationData.addPostInstallTask(new AddAdminUserTask());
      return installationData;
   }

   protected String getLevel(Document doc, String expression) throws XPathExpressionException {
      NodeList consoleLoggerLevel = (NodeList) xPath.compile(expression).evaluate(
         doc, XPathConstants.NODESET);
      return consoleLoggerLevel.item(0).getAttributes().getNamedItem("name").getNodeValue();
   }
}
