package org.jboss.installer.core;

import org.junit.Assert;
import org.junit.Test;

public class VersionGetterTest {

    VersionGetter versionGetter = new VersionGetter("pom_test.properties");

    @Test
    public void getExistentVersionTest() {
        String testVersion = versionGetter.getVersionFromPomProperties("test.version");
        Assert.assertEquals("test", testVersion);
    }

    @Test
    public void getNonExistentPropertyThrowsExceptionTest() {
        Assert.assertThrows(InstallerRuntimeException.class, () -> {
            versionGetter.getVersionFromPomProperties("non.existent.version");
        });
    }
}
