/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.test.integration.ejb.mdb.timerservice;

import static org.jboss.as.test.shared.PermissionUtils.createPermissionsXmlAsset;

import java.util.PropertyPermission;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicSession;
import javax.naming.InitialContext;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.test.jms.auxiliary.CreateTopicSetupTask;
import org.jboss.as.test.shared.TimeoutUtil;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * Tests that an @Timout method is called when a timer is created programatically.
 *
 * @author Stuart Douglas
 */
@RunWith(Arquillian.class)
@ServerSetup(CreateTopicSetupTask.class)
public class SimpleTimerMDBTestCase {

    @Deployment
    public static Archive<?> deploy() {
        final WebArchive war = ShrinkWrap.create(WebArchive.class, "testTimerServiceSimple.war");
        war.addPackage(SimpleTimerMDBTestCase.class.getPackage());
        war.addClass(CreateTopicSetupTask.class);
        war.addClass(TimeoutUtil.class);
        war.addAsManifestResource(createPermissionsXmlAsset(
                new PropertyPermission("ts.timeout.factor", "read")
        ), "permissions.xml");
        return war;

    }

    @Test
    public void testAnnotationTimeoutMethod() throws Exception {
        sendMessage();
        Assert.assertTrue(AnnotationTimerServiceMDB.awaitTimerCall());
    }

    @Test
    public void testTimedObjectTimeoutMethod() throws Exception {
        sendMessage();
        Assert.assertTrue(TimedObjectTimerServiceMDB.awaitTimerCall(TimeoutUtil.adjust(2000)));
    }

    //the timer is created when the
    public void sendMessage() throws Exception {
        final InitialContext ctx = new InitialContext();
        final TopicConnectionFactory factory = (TopicConnectionFactory) ctx.lookup("java:/JmsXA");
        try (TopicConnection connection = factory.createTopicConnection()){
            connection.start();
            final TopicSession session = connection.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
            final Message message = session.createTextMessage("Test");
            final Destination destination = (Destination) ctx.lookup("topic/myAwesomeTopic");
            try (MessageProducer producer = session.createProducer(destination)) {
                producer.send(message);
            }
        }
        ctx.close();
    }
}
