/*
 * Copyright The WildFly Authors
 * SPDX-License-Identifier: Apache-2.0
 */
package org.jboss.as.cli.handlers.ifelse;


import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;


/**
 *
 * @author Alexey Loubyansky
 */
public class ElseHandler extends CommandHandlerWithHelp {

    public ElseHandler() {
        super("else", true);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        final IfElseControlFlow ifElse = IfElseControlFlow.get(ctx);
        return ifElse != null && ifElse.isInIf();
    }

    /* (non-Javadoc)
     * @see org.jboss.as.cli.handlers.CommandHandlerWithHelp#doHandle(org.jboss.as.cli.CommandContext)
     */
    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        final IfElseControlFlow ifElse = IfElseControlFlow.get(ctx);
        if(ifElse == null) {
            throw new CommandLineException("else is not available outside the if-else control flow");
        }
        if(ifElse.isInIf()) {
            ifElse.moveToElse();
        } else {
            throw new CommandLineException("only one else block is supported after the if");
        }
    }
}
