package org.jboss.installer.panels;

import javax.swing.ScrollPaneLayout;
import javax.swing.UIManager;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;

/**
 * A custom ScrollPaneLayout that always reserves space for the vertical scrollbar,
 * preventing horizontal jumping of content when the scrollbar appears or disappears.
 */
public class StableScrollPaneLayout extends ScrollPaneLayout {

    @Override
    public void layoutContainer(Container parent) {
        super.layoutContainer(parent);

        boolean isVsbVisible = vsb != null && vsb.isVisible();

        if (!isVsbVisible && viewport != null) {
            Rectangle viewportBounds = viewport.getBounds();
            Insets insets = parent.getInsets();
            int scrollbarWidth = (Integer) UIManager.get("ScrollBar.width");

            viewportBounds.width = parent.getWidth() - (insets.left + insets.right) - scrollbarWidth;
            viewport.setBounds(viewportBounds);
        }
    }
}