/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.screens;

import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.Screen;
import org.jboss.installer.postinstall.PostInstallTask;
import org.jboss.installer.postinstall.task.AbstractHttpsEnableConfig;
import org.jboss.installer.postinstall.task.ApplicationHttpsConfig;

import java.util.Set;

public class JSSESecurityScreen extends AbstractSSLSecurityScreen {

    public static final String NAME = "JSSESecurityScreen";
    public static final String TITLE_KEY="jsse_security.title";
    public static final String DESCRIPTION_KEY = "ssl.config.application.description";

    public JSSESecurityScreen(Screen parent, LanguageUtils langUtils, boolean isActive) {
        super(parent, langUtils, isActive, DESCRIPTION_KEY, false);
    }

    @Override
    public String getTitle() {
        return langUtils.getString(TITLE_KEY);
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected PostInstallTask createTask() {
        return PostInstallTask.EnableHttpsApplication;
    }

    protected AbstractHttpsEnableConfig createConfig(Set<String> protocols, String cipherSuites, String tls13cipherNames,
                                                     String keyStorePath, String keyStorePassword, boolean mutual, String trustStorePath, String trustStorePassword,
                                                     boolean doGenerateStore, String dn, String validity, String clientCertPath, boolean validateCertificate) {

        return new ApplicationHttpsConfig(protocols, cipherSuites, tls13cipherNames, keyStorePath, keyStorePassword, mutual,
                trustStorePath, trustStorePassword, doGenerateStore, dn, validity, clientCertPath, validateCertificate);
    }

    @Override
    protected Class<? extends AbstractHttpsEnableConfig> getConfigClass() {
        return ApplicationHttpsConfig.class;
    }

    @Override
    protected String getSummaryDescription() {
        return ConfigureRuntimeEnvironmentScreen.JSSE_SECURITY_KEY;
    }
}
