/*
 * Copyright 2022 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.uninstaller;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jboss.installer.test.utils.TestServer;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

public class UninstallerTest {

    private Path testDir;

    @Rule
    public TestServer testServer = new TestServer();

    @Before
    public void init() throws Exception {
        testDir = Paths.get("target/test-uninstall-server");
        if (Files.exists(testDir)) {
            FileUtils.deleteDirectory(testDir.toFile());
        }
        FileUtils.copyDirectory(TestServer.TARGET_PATH.toFile(), testDir.toFile());
    }

    @After
    public void destroy() throws Exception {
        if(testDir.toFile().exists()){
            FileUtils.deleteDirectory(testDir.toFile());
        }
    }

    @Test
    public void testUninstallerJar() throws Exception {
        ProcessBuilder procBuilder = new ProcessBuilder(getJavaExecutable(), "-jar",
                testDir.resolve("uninstaller").resolve("uninstaller.jar").toString(), "" +
                "-console");

        procBuilder.redirectErrorStream(true);
        Process proc = procBuilder.start();
        assertTrue(proc.waitFor(30, TimeUnit.SECONDS));

        String out = "sout: " + IOUtils.toString(new InputStreamReader(proc.getInputStream()));
        out +=  "sterr:" + IOUtils.toString(new InputStreamReader(proc.getErrorStream()));
        System.out.println(out);
        assertEquals(out,0, proc.exitValue());

        assertFalse(allFilesDeleted());
    }

    private static String getJavaExecutable() {
        final String javaHome = System.getenv("JAVA_HOME");
        final String javaExec;
        if (javaHome != null) {
            javaExec = javaHome + File.separator + "bin" + File.separator + "java";
        } else {
            javaExec = "java";
        }
        return javaExec;
    }

    private boolean allFilesDeleted() {
        return !Files.exists(testDir);
    }
}


