package org.jboss.installer.postinstall;

import org.jboss.installer.core.InstallationData;

public interface SimplePostInstallTaskImpl extends PostInstallTaskImpl {

    /**
     * Applies changes to the server's installation. Called only once per installation (i.e. no separate calls for
     * domain/standalone servers or server configurations). The server is not running during the call to this method.
     * <p>
     * Returning {@code false} from the task will prevent any subsequent tasks from running and fail the installation.
     *
     * @param data
     * @param printer - {@code TaskPrinter} used to communicate with GUI
     * @return true if the task was successful, false otherwise
     */
    boolean applyToInstallation(InstallationData data, TaskPrinter printer);
}
