package org.jboss.installer;

import java.util.Locale;
import java.util.Objects;

import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.i18n.DefaultLanguageUtils;

public class SystemProperties {

    /*
     * default lang utils to get translations if no langUtils is set
     */
    private static LanguageUtils langUtils = DefaultLanguageUtils.builder().setLocale(Locale.getDefault()).build();

    /**
     * Overrides default installer quickstarts repository URL
     *
     * Internal property, should be used in testing only.
     */
    public static final String OVERRIDE_QUICKSTARTS_URL = "installer.internal.quickstarts.url";
    /**
     * Overrides default installer quickstarts repository branch
     *
     * Internal property, should be used in testing only.
     */
    public static final String OVERRIDE_QUICKSTARTS_BRANCH = "installer.internal.quickstarts.branch";
    /**
     *Overrides default repositories used to install the server.
     *
     * Internal property, should be used in testing only.
     */
    public static final String INSTALLER_OVERRIDE_MAVEN_REPOSITORIES = "installer.override.maven.repositories";

    public static String getInternalProperty(String key, String defaultValue) {
        final String value = System.getProperty(key);

        if (value == null) {
            return defaultValue;
        } else {
            System.err.println(langUtils.getString("warn.internal.property.used", key, defaultValue));
            return value;
        }
    }

    /**
     * Override default locale used for messages translation.
     *
     * @param langUtils
     */
    public static void setLangUtils(LanguageUtils langUtils) {
        Objects.requireNonNull(langUtils);
        SystemProperties.langUtils = langUtils;
    }
}
