/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.screens;

import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.Screen;

import java.util.List;

public class DomainHostPortConfigurationScreen extends CustomPortConfigurationScreen{

    public static final String NAME = "DomainHostPortConfigurationScreen";
    public static final String SIDE_NAV_NAME_KEY = "port.config.domain.host.side_nav_name";

    public DomainHostPortConfigurationScreen(Screen parent, LanguageUtils langUtils, boolean isActive) {
        super(parent, langUtils, isActive);
        properties = List.of(MANAGEMENT_HTTP_KEY);
    }

    @Override
    protected String getConfigName() {
        return null;
    }

    @Override
    public String getTitle() {
        return langUtils.getString(TITLE_KEY);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSideNavName() {
        return langUtils.getString(SIDE_NAV_NAME_KEY);
    }
}
