/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.security.acl.config.ACLProviderEntry;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.auth.login.LoginConfigObjectModelFactory;
import org.jboss.security.authorization.config.AuthorizationConfigEntryHolder;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.config.ModuleOption;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class SecurityConfigObjectModelFactory
extends LoginConfigObjectModelFactory {
    private static Logger log = Logger.getLogger(SecurityConfigObjectModelFactory.class);
    private final boolean trace = log.isTraceEnabled();

    public Object newChild(ApplicationPolicy aPolicy, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        Object child = super.newChild(aPolicy, navigator, namespaceUri, localName, attrs);
        if (child == null && "authorization".equals(localName)) {
            child = new AuthorizationInfo(aPolicy.getName());
        } else if (child == null && "acl".equals(localName)) {
            child = new ACLInfo(aPolicy.getName());
        } else if (child == null && "mapping".equals(localName)) {
            child = new MappingInfo(aPolicy.getName());
        } else if (child == null && "rolemapping".equals(localName)) {
            child = new MappingInfo(aPolicy.getName());
        } else if (child == null && "audit".equals(localName)) {
            child = new AuditInfo(aPolicy.getName());
        } else if (child == null && "identity-trust".equals(localName)) {
            child = new IdentityTrustInfo(aPolicy.getName());
        }
        return child;
    }

    public Object newChild(AuthorizationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        AuthorizationModuleEntry child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AuthorizationInfo, localName: " + localName));
        }
        if ("policy-module".equals(localName)) {
            ControlFlag controlFlag;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            String flag = attrs.getValue("flag");
            if (flag == null) {
                flag = "REQUIRED";
            }
            if ((controlFlag = (ControlFlag)this.controlFlags.get((flag = StringPropertyReplacer.replaceProperties((String)flag.trim())).toUpperCase())) == null) {
                controlFlag = ControlFlag.REQUIRED;
            }
            AuthorizationModuleEntry entry = new AuthorizationModuleEntry(code);
            entry.setControlFlag(controlFlag);
            child = entry;
            if (this.trace) {
                log.trace((Object)("newChild.AuthorizationInfo, policy-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(AuthorizationModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AppConfigurationEntryHolder, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.AuthModuleEntry, module-option name: " + name));
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, AuthorizationInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setAuthorizationInfo(authInfo);
        if (this.trace) {
            log.trace((Object)("addChild.ApplicationPolicy, name: " + aPolicy.getName()));
        }
    }

    public void addChild(AuthorizationInfo authInfo, AuthorizationConfigEntryHolder entryInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        AuthorizationModuleEntry entry = entryInfo.getEntry();
        authInfo.add(entry);
        if (this.trace) {
            log.trace((Object)("addChild.AuthorizationInfo, name: " + entry.getPolicyModuleName()));
        }
    }

    public void addChild(AuthorizationConfigEntryHolder entryInfo, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entryInfo.addOption(option);
        if (this.trace) {
            log.trace((Object)("addChild.AuthorizationConfigEntryHolder, name: " + option.getName()));
        }
    }

    public void addChild(AuthorizationInfo authInfo, AuthorizationModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        authInfo.add(entry);
    }

    public void addChild(AuthorizationModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.add(option);
        if (this.trace) {
            log.trace((Object)("addChild.AuthorizationModuleEntry, name: " + option.getName()));
        }
    }

    public Object newChild(ACLInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ACLProviderEntry child = null;
        if (this.trace) {
            log.trace((Object)("newChild.ACLInfo, localName: " + localName));
        }
        if ("acl-module".equals(localName)) {
            ControlFlag controlFlag;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            String flag = attrs.getValue("flag");
            if (flag == null) {
                flag = "REQUIRED";
            }
            if ((controlFlag = (ControlFlag)this.controlFlags.get((flag = StringPropertyReplacer.replaceProperties((String)flag.trim())).toUpperCase())) == null) {
                controlFlag = ControlFlag.REQUIRED;
            }
            ACLProviderEntry entry = new ACLProviderEntry(code);
            entry.setControlFlag(controlFlag);
            child = entry;
            if (this.trace) {
                log.trace((Object)("newChild.ACLInfo, acl-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(ACLProviderEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.ACLProviderEntry, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.trustProviderEntry, module-option name: " + name));
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, ACLInfo aclInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setAclInfo(aclInfo);
        if (this.trace) {
            log.trace((Object)("Adding ACLInfo as a child of ApplicationPolicy " + aPolicy.getName()));
        }
    }

    public void addChild(ACLInfo aclInfo, ACLProviderEntry aclEntry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aclInfo.add(aclEntry);
        if (this.trace) {
            log.trace((Object)("Adding ACLProviderEntry " + aclEntry.getAclProviderName() + " to ACLInfo " + aclInfo.getName()));
        }
    }

    public void addChild(ACLProviderEntry aclEntry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aclEntry.add(option);
        if (this.trace) {
            log.trace((Object)("Adding module-option " + option.getName() + " to ACLProviderEntry " + aclEntry.getAclProviderName()));
        }
    }

    public Object newChild(MappingInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        MappingModuleEntry child = null;
        if (this.trace) {
            log.trace((Object)("newChild.MappingInfo, localName: " + localName));
        }
        if ("mapping-module".equals(localName)) {
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            String type = attrs.getValue("type");
            type = type != null ? StringPropertyReplacer.replaceProperties((String)type.trim()) : "role";
            child = new MappingModuleEntry(code, new HashMap<String, Object>(), type);
            if (this.trace) {
                log.trace((Object)("newChild.MappingInfo, mapping-module code: " + code + ", mapping-module type: " + type));
            }
        }
        return child;
    }

    public Object newChild(MappingModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.MappingModuleEntry, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.MappingModuleEntry, module-option name: " + name));
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, MappingInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        HashMap mappings = new HashMap();
        for (MappingModuleEntry mappingModuleEntry : authInfo.getModuleEntries()) {
            String type = mappingModuleEntry.getMappingModuleType();
            if (mappings.containsKey(type)) {
                ((List)mappings.get(type)).add(mappingModuleEntry);
                continue;
            }
            ArrayList<MappingModuleEntry> entries = new ArrayList<MappingModuleEntry>();
            entries.add(mappingModuleEntry);
            mappings.put(type, entries);
        }
        for (Map.Entry entry : mappings.entrySet()) {
            MappingInfo info = new MappingInfo(authInfo.getName());
            info.add((List)entry.getValue());
            aPolicy.setMappingInfo((String)entry.getKey(), info);
        }
        if (this.trace) {
            log.trace((Object)("addChild.ApplicationPolicy, name: " + aPolicy.getName()));
        }
    }

    public void addChild(MappingModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.add(option);
        if (this.trace) {
            log.trace((Object)("addChild.MappingModuleEntry, name: " + option.getName()));
        }
    }

    public void addChild(MappingInfo authInfo, MappingModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        authInfo.add(entry);
    }

    public Object newChild(AuditInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        AuditProviderEntry child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AuditInfo, localName: " + localName));
        }
        if ("provider-module".equals(localName)) {
            AuditProviderEntry entry;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            child = entry = new AuditProviderEntry(code);
            if (this.trace) {
                log.trace((Object)("newChild.AuditInfo, provider-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(AuditProviderEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AuditProviderEntry, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.AuditProviderEntry, module-option name: " + name));
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, AuditInfo auditInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setAuditInfo(auditInfo);
        if (this.trace) {
            log.trace((Object)("addChild.ApplicationPolicy, name: " + aPolicy.getName()));
        }
    }

    public void addChild(AuditProviderEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.add(option);
        if (this.trace) {
            log.trace((Object)("addChild.MappingModuleEntry, name: " + option.getName()));
        }
    }

    public void addChild(AuditInfo auditInfo, AuditProviderEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        auditInfo.add(entry);
    }

    public Object newChild(IdentityTrustInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        IdentityTrustModuleEntry child = null;
        if (this.trace) {
            log.trace((Object)("newChild.IdentityTrustInfo, localName: " + localName));
        }
        if ("trust-module".equals(localName)) {
            ControlFlag controlFlag;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            String flag = attrs.getValue("flag");
            if (flag == null) {
                flag = "REQUIRED";
            }
            if ((controlFlag = (ControlFlag)this.controlFlags.get((flag = StringPropertyReplacer.replaceProperties((String)flag.trim())).toUpperCase())) == null) {
                controlFlag = ControlFlag.REQUIRED;
            }
            IdentityTrustModuleEntry entry = new IdentityTrustModuleEntry(code);
            entry.setControlFlag(controlFlag);
            child = entry;
            if (this.trace) {
                log.trace((Object)("newChild.IdentityTrustInfo, trust-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(IdentityTrustModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.trustProviderEntry, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.trustProviderEntry, module-option name: " + name));
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, IdentityTrustInfo auditInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setIdentityTrustInfo(auditInfo);
        if (this.trace) {
            log.trace((Object)("addChild.ApplicationPolicy, name: " + aPolicy.getName()));
        }
    }

    public void addChild(IdentityTrustModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.add(option);
        if (this.trace) {
            log.trace((Object)("addChild.MappingModuleEntry, name: " + option.getName()));
        }
    }

    public void addChild(IdentityTrustInfo auditInfo, IdentityTrustModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        auditInfo.add(entry);
    }
}

