/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javassist.CtClass;
import javassist.bytecode.Descriptor;

public class ClassLoaderUtils {
    private static final Set<String> primitiveNames;

    public static String getResourceName(String classname) {
        String name = ClassLoaderUtils.stripArrayFromClassName(classname);
        int lastIndex = name.lastIndexOf(36);
        if (lastIndex < 0) {
            return name.replaceAll("[\\.]", "/") + ".class";
        }
        return name.substring(0, lastIndex).replaceAll("[\\.]", "/") + name.substring(lastIndex) + ".class";
    }

    public static String getPackageName(String classname) {
        int last = classname.lastIndexOf(46);
        if (last < 0) {
            return "";
        }
        return classname.substring(0, last);
    }

    public static String stripArrayFromClassName(String classname) {
        if (classname.charAt(0) == '[') {
            return Descriptor.toClassName((String)classname);
        }
        if (classname.endsWith("[]")) {
            return classname.substring(0, classname.indexOf("[]"));
        }
        return classname;
    }

    public static boolean isPrimitiveType(String classname) {
        String name = ClassLoaderUtils.stripArrayFromClassName(classname);
        return primitiveNames.contains(name);
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add(CtClass.booleanType.getName());
        temp.add(CtClass.byteType.getName());
        temp.add(CtClass.charType.getName());
        temp.add(CtClass.doubleType.getName());
        temp.add(CtClass.floatType.getName());
        temp.add(CtClass.intType.getName());
        temp.add(CtClass.longType.getName());
        temp.add(CtClass.shortType.getName());
        temp.add(CtClass.voidType.getName());
        primitiveNames = Collections.unmodifiableSet(temp);
    }
}

