/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.transaction.Transaction;

public class RoutingContextImpl
implements RoutingContext {
    private final List<Queue> nonDurableQueues = new ArrayList<Queue>(1);
    private final List<Queue> durableQueues = new ArrayList<Queue>(1);
    private Transaction transaction;
    private int queueCount;

    public RoutingContextImpl(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void clear() {
        this.transaction = null;
        this.nonDurableQueues.clear();
        this.durableQueues.clear();
        this.queueCount = 0;
    }

    @Override
    public void addQueue(Queue queue) {
        if (queue.isDurable()) {
            this.durableQueues.add(queue);
        } else {
            this.nonDurableQueues.add(queue);
        }
        ++this.queueCount;
    }

    public void addDurableQueue(Queue queue) {
        this.durableQueues.add(queue);
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void setTransaction(Transaction tx) {
        this.transaction = tx;
    }

    @Override
    public List<Queue> getNonDurableQueues() {
        return this.nonDurableQueues;
    }

    @Override
    public List<Queue> getDurableQueues() {
        return this.durableQueues;
    }

    @Override
    public int getQueueCount() {
        return this.queueCount;
    }
}

