/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.template;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.arjuna.template.BasicList;
import com.arjuna.ats.internal.arjuna.template.ListElement;

public class HashList {
    protected BasicList[] buckets;
    protected int maxBucket;

    public HashList(int hashBucket) {
        this.maxBucket = hashBucket;
        this.buckets = new BasicList[hashBucket];
        for (int i = 0; i < hashBucket; ++i) {
            this.buckets[i] = null;
        }
    }

    public synchronized void empty() {
        for (int i = 0; i < this.maxBucket; ++i) {
            if (this.buckets[i] == null) continue;
            this.buckets[i] = null;
        }
    }

    public synchronized int size() {
        int rVal = 0;
        for (int i = 0; i < this.maxBucket; ++i) {
            if (this.buckets[i] == null) continue;
            rVal += this.buckets[i].size();
        }
        return rVal;
    }

    public synchronized boolean add(ListElement th) {
        if (th != null) {
            int entry = th.get_uid().hashCode() % this.maxBucket;
            if (this.buckets[entry] == null) {
                this.buckets[entry] = new BasicList();
            }
            return this.buckets[entry].add(th);
        }
        return false;
    }

    public synchronized boolean insert(ListElement th) {
        if (th != null) {
            int entry = th.get_uid().hashCode() % this.maxBucket;
            if (this.buckets[entry] != null) {
                return this.buckets[entry].insert(th);
            }
            this.buckets[entry] = new BasicList();
            return this.buckets[entry].add(th);
        }
        return false;
    }

    public synchronized boolean remove(ListElement findMe) {
        int entry;
        if (findMe != null && this.buckets[entry = findMe.get_uid().hashCode() % this.maxBucket] != null) {
            return this.buckets[entry].remove(findMe);
        }
        return false;
    }

    public synchronized ListElement remove(Uid findMe) {
        int entry = findMe.hashCode() % this.maxBucket;
        if (this.buckets[entry] != null) {
            return this.buckets[entry].remove(findMe);
        }
        return null;
    }

    public synchronized ListElement lookFor(Uid findMe) {
        int entry = findMe.hashCode() % this.maxBucket;
        if (this.buckets[entry] != null) {
            return this.buckets[entry].lookFor(findMe);
        }
        return null;
    }

    public synchronized ListElement orderedPop() {
        ListElement th = null;
        for (int i = 0; i < this.maxBucket && th != null; ++i) {
            if (this.buckets[i] == null || this.buckets[i].size() <= 0) continue;
            th = this.buckets[i].orderedPop();
        }
        return th;
    }
}

