/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting.html.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class CopyFiles {
    public static void copy(File destinationDir) throws IOException {
        File cssOutputDir = new File(destinationDir, "css");
        File imagesOutputDir = new File(destinationDir, "images");
        File jsOutputDir = new File(destinationDir, "js");
        destinationDir.mkdirs();
        cssOutputDir.mkdir();
        imagesOutputDir.mkdir();
        jsOutputDir.mkdir();
        CopyFiles.copyResourceFromJar("help.css", cssOutputDir);
        CopyFiles.copyResourceFromJar("main.css", cssOutputDir);
        CopyFiles.copyResourceFromJar("sortabletable.css", cssOutputDir);
        CopyFiles.copyResourceFromJar("source-viewer.css", cssOutputDir);
        CopyFiles.copyResourceFromJar("tooltip.css", cssOutputDir);
        CopyFiles.copyResourceFromJar("blank.png", imagesOutputDir);
        CopyFiles.copyResourceFromJar("downsimple.png", imagesOutputDir);
        CopyFiles.copyResourceFromJar("upsimple.png", imagesOutputDir);
        CopyFiles.copyResourceFromJar("customsorttypes.js", jsOutputDir);
        CopyFiles.copyResourceFromJar("popup.js", jsOutputDir);
        CopyFiles.copyResourceFromJar("sortabletable.js", jsOutputDir);
        CopyFiles.copyResourceFromJar("stringbuilder.js", jsOutputDir);
        CopyFiles.copyResourceFromJar("help.html", destinationDir);
        CopyFiles.copyResourceFromJar("index.html", destinationDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyResourceFromJar(String resourceName, File directory) throws IOException {
        byte[] buf = new byte[1024];
        InputStream in = null;
        FileOutputStream out = null;
        directory.mkdirs();
        try {
            int n;
            in = CopyFiles.class.getResourceAsStream(resourceName);
            if (in == null) {
                throw new IllegalArgumentException("Resource " + resourceName + " does not exist in this package.");
            }
            out = new FileOutputStream(new File(directory, resourceName));
            while ((n = in.read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, n);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

