/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.component;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.el.ValueExpression;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;

public abstract class UIFileUpload
extends UIInput {
    private String localContentType;
    private String localFileName;
    private Integer localFileSize;
    private InputStream localInputStream;

    public void processUpdates(FacesContext context) {
        ValueExpression dataBinding = this.getValueExpression("data");
        if (dataBinding != null) {
            Class clazz;
            ValueExpression valueExpression;
            if (this.getLocalContentType() != null && (valueExpression = this.getValueExpression("contentType")) != null) {
                valueExpression.setValue(context.getELContext(), (Object)this.getLocalContentType());
            }
            if (this.getLocalFileName() != null && (valueExpression = this.getValueExpression("fileName")) != null) {
                valueExpression.setValue(context.getELContext(), (Object)this.getLocalFileName());
            }
            if (this.getLocalFileSize() != null && (valueExpression = this.getValueExpression("fileSize")) != null) {
                valueExpression.setValue(context.getELContext(), (Object)this.getLocalFileSize());
            }
            if ((clazz = dataBinding.getType(context.getELContext())).isAssignableFrom(InputStream.class)) {
                dataBinding.setValue(context.getELContext(), (Object)this.getLocalInputStream());
            } else if (clazz.isAssignableFrom(byte[].class)) {
                byte[] bytes = null;
                if (this.getLocalInputStream() != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        byte[] buffer = new byte[512];
                        int read = this.getLocalInputStream().read(buffer);
                        while (read != -1) {
                            bos.write(buffer, 0, read);
                            read = this.getLocalInputStream().read(buffer);
                        }
                        bytes = bos.toByteArray();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                dataBinding.setValue(context.getELContext(), bytes);
            }
        }
    }

    public String getLocalContentType() {
        return this.localContentType;
    }

    public void setLocalContentType(String localContentType) {
        this.localContentType = localContentType;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public void setLocalFileName(String localFileName) {
        this.localFileName = this.extractFilename(localFileName);
    }

    private String extractFilename(String filename) {
        if (filename != null && filename.lastIndexOf("\\") > -1) {
            return filename.substring(filename.lastIndexOf("\\") + 1);
        }
        return filename;
    }

    public Integer getLocalFileSize() {
        return this.localFileSize;
    }

    public void setLocalFileSize(Integer localFileSize) {
        this.localFileSize = localFileSize;
    }

    public InputStream getLocalInputStream() {
        return this.localInputStream;
    }

    public void setLocalInputStream(InputStream localInputStream) {
        this.localInputStream = localInputStream;
    }

    public abstract void setAccept(String var1);

    public abstract String getAccept();

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String var1);

    public abstract void setStyle(String var1);
}

