/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractDelegatingCacheLoader;
import org.jboss.cache.loader.AsyncCacheLoaderConfig;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncCacheLoader
extends AbstractDelegatingCacheLoader {
    private static final Log log = LogFactory.getLog(AsyncCacheLoader.class);
    private static final boolean trace = log.isTraceEnabled();
    private static AtomicInteger threadId = new AtomicInteger(0);
    private static final int DEFAULT_QUEUE_SIZE = 10000;
    private AsyncCacheLoaderConfig config;
    private ExecutorService executor;
    private AtomicBoolean stopped = new AtomicBoolean(true);
    private BlockingQueue<Modification> queue = new ArrayBlockingQueue<Modification>(10000);
    private List<Future> processorFutures;

    public AsyncCacheLoader() {
        super(null);
    }

    public AsyncCacheLoader(CacheLoader cacheLoader) {
        super(cacheLoader);
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof AsyncCacheLoaderConfig ? (AsyncCacheLoaderConfig)base : new AsyncCacheLoaderConfig(base);
        if (this.config.getQueueSize() > 0) {
            this.queue = new ArrayBlockingQueue<Modification>(this.config.getQueueSize());
        }
        super.setConfig(base);
    }

    @Override
    public Map get(Fqn name) throws Exception {
        try {
            return super.get(name);
        }
        catch (IOException e) {
            log.trace((Object)e);
            return new HashMap();
        }
    }

    Object get(Fqn name, Object key) throws Exception {
        if (this.config.getReturnOld()) {
            try {
                Map map = super.get(name);
                if (map != null) {
                    return map.get(key);
                }
            }
            catch (IOException e) {
                log.trace((Object)e);
            }
        }
        return null;
    }

    @Override
    public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception {
        if (one_phase) {
            this.put(modifications);
        } else {
            this.transactions.put(tx, modifications);
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        List modifications = (List)this.transactions.remove(tx);
        if (modifications == null) {
            throw new Exception("transaction " + tx + " not found in transaction table");
        }
        this.put(modifications);
    }

    @Override
    public void rollback(Object tx) {
        this.transactions.remove(tx);
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (this.config.getUseAsyncPut()) {
            Object oldValue = this.get(name, key);
            Modification mod = new Modification(Modification.ModificationType.PUT_KEY_VALUE, name, key, value);
            this.enqueue(mod);
            return oldValue;
        }
        return super.put(name, key, value);
    }

    @Override
    public void put(Fqn name, Map attributes) throws Exception {
        if (this.config.getUseAsyncPut()) {
            Map attrs = attributes == null ? null : Immutables.immutableMapCopy(attributes);
            Modification mod = new Modification(Modification.ModificationType.PUT_DATA, name, attrs);
            this.enqueue(mod);
        } else {
            super.put(name, attributes);
        }
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        if (this.config.getUseAsyncPut()) {
            for (Modification modification : modifications) {
                this.enqueue(modification);
            }
        } else {
            super.put(modifications);
        }
    }

    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        Object oldValue = this.get(name, key);
        Modification mod = new Modification(Modification.ModificationType.REMOVE_KEY_VALUE, name, key);
        this.enqueue(mod);
        return oldValue;
    }

    @Override
    public void remove(Fqn name) throws Exception {
        Modification mod = new Modification(Modification.ModificationType.REMOVE_NODE, name);
        this.enqueue(mod);
    }

    @Override
    public void removeData(Fqn name) throws Exception {
        Modification mod = new Modification(Modification.ModificationType.REMOVE_DATA, name);
        this.enqueue(mod);
    }

    @Override
    public void start() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Async cache loader starting: " + this));
        }
        this.stopped.set(false);
        super.start();
        this.executor = Executors.newFixedThreadPool(this.config.getThreadPoolSize(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "AsyncCacheLoader-" + threadId.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
        this.processorFutures = new ArrayList<Future>(this.config.getThreadPoolSize());
        for (int i = 0; i < this.config.getThreadPoolSize(); ++i) {
            this.processorFutures.add(this.executor.submit(new AsyncProcessor()));
        }
    }

    @Override
    public void stop() {
        this.stopped.set(true);
        if (this.executor != null) {
            for (Future f : this.processorFutures) {
                f.cancel(true);
            }
            this.executor.shutdown();
            try {
                boolean terminated = this.executor.isTerminated();
                while (!terminated) {
                    terminated = this.executor.awaitTermination(60L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.executor = null;
        super.stop();
    }

    private void enqueue(Modification mod) throws CacheException, InterruptedException {
        if (this.stopped.get()) {
            throw new CacheException("AsyncCacheLoader stopped; no longer accepting more entries.");
        }
        if (trace) {
            log.trace((Object)("Enqueuing modification " + mod));
        }
        this.queue.put(mod);
    }

    public String toString() {
        return super.toString() + " delegate=[" + super.getCacheLoader() + "]" + " stopped=" + this.stopped + " batchSize=" + this.config.getBatchSize() + " returnOld=" + this.config.getReturnOld() + " asyncPut=" + this.config.getUseAsyncPut() + " threadPoolSize=" + this.config.getThreadPoolSize() + " queue.remainingCapacity()=" + this.queue.remainingCapacity() + " queue.peek()=" + this.queue.peek();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncProcessor
    implements Runnable {
        private final List<Modification> mods;

        private AsyncProcessor() {
            this.mods = new ArrayList<Modification>(AsyncCacheLoader.this.config.getBatchSize());
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    this.run0();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            try {
                if (trace) {
                    log.trace((Object)("process remaining batch " + this.mods.size()));
                }
                this.put(this.mods);
                if (trace) {
                    log.trace((Object)("process remaining queued " + AsyncCacheLoader.this.queue.size()));
                }
                while (!AsyncCacheLoader.this.queue.isEmpty()) {
                    this.run0();
                }
            }
            catch (InterruptedException e) {
                log.trace((Object)"remaining interrupted");
            }
        }

        private void run0() throws InterruptedException {
            log.trace((Object)"Checking for modifications");
            int i = AsyncCacheLoader.this.queue.drainTo(this.mods, AsyncCacheLoader.this.config.getBatchSize());
            if (i == 0) {
                Modification m = (Modification)AsyncCacheLoader.this.queue.take();
                this.mods.add(m);
            }
            if (trace) {
                log.trace((Object)("Calling put(List) with " + this.mods.size() + " modifications"));
            }
            this.put(this.mods);
            this.mods.clear();
        }

        private void put(List<Modification> mods) {
            block3: {
                try {
                    AsyncCacheLoader.super.put(mods);
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Failed to process async modifications: " + e));
                    }
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Exception: ", (Throwable)e);
                }
            }
        }
    }
}

