/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.Version;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataExceptionMarker;
import org.jboss.cache.statetransfer.DefaultStateTransferManager;
import org.jboss.cache.statetransfer.StateTransferGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LegacyStateTransferGenerator
implements StateTransferGenerator {
    public static final short STATE_TRANSFER_VERSION = Version.getVersionShort("2.0.0.GA");
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private CacheSPI cache;
    private Set<Fqn> internalFqns;

    @Inject
    public void inject(CacheSPI cache) {
        this.cache = cache;
    }

    @Start(priority=14)
    void start() {
        this.internalFqns = this.cache.getInternalFqns();
        this.log.trace((Object)("LegacyStateTransferGenerator.start: internalFqn is " + this.internalFqns));
    }

    @Override
    public void generateState(ObjectOutputStream out, Object rootNode, boolean generateTransient, boolean generatePersistent, boolean suppressErrors) throws Exception {
        Fqn fqn = this.getFqn(rootNode);
        try {
            CacheLoader cacheLoader;
            this.cache.getMarshaller().objectToObjectStream(STATE_TRANSFER_VERSION, out);
            if (generateTransient) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("writing transient state for " + fqn));
                }
                this.marshallTransientState((NodeSPI)rootNode, out);
                this.delimitStream(out);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"transient state succesfully written");
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"writing associated state");
                }
                this.delimitStream(out);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"associated state succesfully written");
                }
            } else {
                this.delimitStream(out);
                this.delimitStream(out);
            }
            CacheLoader cacheLoader2 = cacheLoader = this.cache.getCacheLoaderManager() == null ? null : this.cache.getCacheLoaderManager().getCacheLoader();
            if (cacheLoader != null && generatePersistent) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("writing persistent state for " + fqn + ",using " + this.cache.getCacheLoaderManager().getCacheLoader().getClass()));
                }
                if (fqn.isRoot()) {
                    cacheLoader.loadEntireState(out);
                } else {
                    cacheLoader.loadState(fqn, out);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"persistent state succesfully written");
                }
            }
            this.delimitStream(out);
        }
        catch (Exception e) {
            this.cache.getMarshaller().objectToObjectStream(new NodeDataExceptionMarker(e, this.cache.getLocalAddress()), out);
            throw e;
        }
    }

    private Fqn getFqn(Object o) {
        if (o instanceof Node) {
            return ((Node)o).getFqn();
        }
        if (o instanceof InternalNode) {
            return ((InternalNode)o).getFqn();
        }
        throw new IllegalArgumentException();
    }

    protected void delimitStream(ObjectOutputStream out) throws Exception {
        this.cache.getMarshaller().objectToObjectStream(DefaultStateTransferManager.STREAMING_DELIMITER_NODE, out);
    }

    protected void marshallTransientState(NodeSPI node, ObjectOutputStream out) throws Exception {
        LinkedList<NodeData> nodeData = new LinkedList<NodeData>();
        this.generateNodeDataList(node, nodeData);
        this.cache.getMarshaller().objectToObjectStream(nodeData, out, node.getFqn());
    }

    protected void generateNodeDataList(NodeSPI<?, ?> node, List<NodeData> list) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("generateNodeDataList: internalFqns are:" + this.internalFqns + ", node is: " + node));
        }
        if (this.internalFqns.contains(node.getFqn())) {
            return;
        }
        Map attrs = node.getInternalState(false);
        NodeData nd = attrs.size() == 0 ? new NodeData(node.getFqn()) : new NodeData(node.getFqn(), attrs, true);
        list.add(nd);
        for (NodeSPI<?, ?> child : node.getChildrenDirect()) {
            this.generateNodeDataList(child, list);
        }
    }
}

