/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;

class BeanDefinitionValueResolver {
    private final AbstractBeanFactory beanFactory;
    private final String beanName;
    private final BeanDefinition beanDefinition;
    private final TypeConverter typeConverter;

    public BeanDefinitionValueResolver(AbstractBeanFactory beanFactory, String beanName, BeanDefinition beanDefinition, TypeConverter typeConverter) {
        this.beanFactory = beanFactory;
        this.beanName = beanName;
        this.beanDefinition = beanDefinition;
        this.typeConverter = typeConverter;
    }

    public Object resolveValueIfNecessary(Object argName, Object value) {
        if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            return this.resolveReference(argName, ref);
        }
        if (value instanceof RuntimeBeanNameReference) {
            String ref = ((RuntimeBeanNameReference)value).getBeanName();
            if (!this.beanFactory.containsBean(ref)) {
                throw new BeanDefinitionStoreException("Invalid bean name '" + ref + "' in bean reference for " + argName);
            }
            return ref;
        }
        if (value instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder bdHolder = (BeanDefinitionHolder)value;
            return this.resolveInnerBean(argName, bdHolder.getBeanName(), bdHolder.getBeanDefinition());
        }
        if (value instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)value;
            return this.resolveInnerBean(argName, "(inner bean)", bd);
        }
        if (value instanceof ManagedList) {
            return this.resolveManagedList(argName, (List)value);
        }
        if (value instanceof ManagedSet) {
            return this.resolveManagedSet(argName, (Set)value);
        }
        if (value instanceof ManagedMap) {
            return this.resolveManagedMap(argName, (Map)value);
        }
        if (value instanceof ManagedProperties) {
            Properties original = (Properties)value;
            Properties copy = new Properties();
            Iterator<Map.Entry<Object, Object>> it = original.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> propEntry = it.next();
                Object propKey = propEntry.getKey();
                Object propValue = propEntry.getValue();
                if (propKey instanceof TypedStringValue) {
                    propKey = ((TypedStringValue)propKey).getValue();
                }
                if (propValue instanceof TypedStringValue) {
                    propValue = ((TypedStringValue)propValue).getValue();
                }
                copy.put(propKey, propValue);
            }
            return copy;
        }
        if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            try {
                Class resolvedTargetType = this.resolveTargetType(typedStringValue);
                if (resolvedTargetType != null) {
                    return this.typeConverter.convertIfNecessary(typedStringValue.getValue(), resolvedTargetType);
                }
                return typedStringValue.getValue();
            }
            catch (Throwable ex) {
                throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Error converting typed String value for " + argName, ex);
            }
        }
        return value;
    }

    protected Class resolveTargetType(TypedStringValue value) throws ClassNotFoundException {
        if (value.hasTargetType()) {
            return value.getTargetType();
        }
        return value.resolveTargetType(this.beanFactory.getBeanClassLoader());
    }

    private Object resolveInnerBean(Object argName, String innerBeanName, BeanDefinition innerBd) {
        RootBeanDefinition mbd = null;
        try {
            String[] dependsOn;
            mbd = this.beanFactory.getMergedBeanDefinition(innerBeanName, innerBd, this.beanDefinition);
            String actualInnerBeanName = innerBeanName;
            if (mbd.isSingleton()) {
                actualInnerBeanName = this.adaptInnerBeanName(innerBeanName);
            }
            if ((dependsOn = mbd.getDependsOn()) != null) {
                for (int i = 0; i < dependsOn.length; ++i) {
                    String dependsOnBean = dependsOn[i];
                    this.beanFactory.getBean(dependsOnBean);
                    this.beanFactory.registerDependentBean(dependsOnBean, actualInnerBeanName);
                }
            }
            Object innerBean = this.beanFactory.createBean(actualInnerBeanName, mbd, null);
            this.beanFactory.registerContainedBean(actualInnerBeanName, this.beanName);
            if (innerBean instanceof FactoryBean) {
                boolean synthetic = mbd != null && mbd.isSynthetic();
                return this.beanFactory.getObjectFromFactoryBean((FactoryBean)innerBean, actualInnerBeanName, !synthetic);
            }
            return innerBean;
        }
        catch (BeansException ex) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot create inner bean '" + innerBeanName + "' " + (mbd != null && mbd.getBeanClassName() != null ? "of type [" + mbd.getBeanClassName() + "] " : "") + "while setting " + argName, (Throwable)((Object)ex));
        }
    }

    private String adaptInnerBeanName(String innerBeanName) {
        String actualInnerBeanName = innerBeanName;
        int counter = 0;
        while (this.beanFactory.isBeanNameInUse(actualInnerBeanName)) {
            actualInnerBeanName = innerBeanName + "#" + ++counter;
        }
        return actualInnerBeanName;
    }

    private Object resolveReference(Object argName, RuntimeBeanReference ref) {
        try {
            if (ref.isToParent()) {
                if (this.beanFactory.getParentBeanFactory() == null) {
                    throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Can't resolve reference to bean '" + ref.getBeanName() + "' in parent factory: no parent factory available");
                }
                return this.beanFactory.getParentBeanFactory().getBean(ref.getBeanName());
            }
            Object bean = this.beanFactory.getBean(ref.getBeanName());
            this.beanFactory.registerDependentBean(ref.getBeanName(), this.beanName);
            return bean;
        }
        catch (BeansException ex) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot resolve reference to bean '" + ref.getBeanName() + "' while setting " + argName, (Throwable)((Object)ex));
        }
    }

    private List resolveManagedList(Object argName, List ml) {
        ArrayList<Object> resolved = new ArrayList<Object>(ml.size());
        for (int i = 0; i < ml.size(); ++i) {
            resolved.add(this.resolveValueIfNecessary(argName + " with key " + "[" + i + "]", ml.get(i)));
        }
        return resolved;
    }

    private Set resolveManagedSet(Object argName, Set ms) {
        LinkedHashSet<Object> resolved = new LinkedHashSet<Object>(ms.size());
        int i = 0;
        Iterator it = ms.iterator();
        while (it.hasNext()) {
            resolved.add(this.resolveValueIfNecessary(argName + " with key " + "[" + i + "]", it.next()));
            ++i;
        }
        return resolved;
    }

    private Map resolveManagedMap(Object argName, Map mm) {
        LinkedHashMap<Object, Object> resolved = new LinkedHashMap<Object, Object>(mm.size());
        Iterator it = mm.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object resolvedKey = this.resolveValueIfNecessary(argName, entry.getKey());
            Object resolvedValue = this.resolveValueIfNecessary(argName + " with key " + "[" + entry.getKey() + "]", entry.getValue());
            resolved.put(resolvedKey, resolvedValue);
        }
        return resolved;
    }
}

