/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.container;

import java.util.LinkedHashMap;
import java.util.List;
import org.jboss.ejb3.interceptors.container.BeanContext;

public class DummyBeanContext<T>
implements BeanContext<T> {
    private T instance;
    private Object[] interceptors;
    private LinkedHashMap<Class<?>, Object> interceptorsMap = new LinkedHashMap();

    public DummyBeanContext(T instance, List<Object> interceptors) {
        assert (instance != null) : "instance is null";
        assert (interceptors != null) : "interceptors is null";
        this.instance = instance;
        this.interceptors = interceptors.toArray(new Object[0]);
        for (Object interceptor : interceptors) {
            this.interceptorsMap.put(interceptor.getClass(), interceptor);
        }
    }

    @Override
    public T getInstance() {
        return this.instance;
    }

    @Override
    public Object getInterceptor(Class<?> interceptorClass) throws IllegalArgumentException {
        Object interceptor = this.interceptorsMap.get(interceptorClass);
        if (interceptor == null) {
            throw new IllegalArgumentException("No interceptor found for " + interceptorClass + " in " + this);
        }
        return interceptor;
    }

    public Object[] getInterceptors() {
        return this.interceptors;
    }
}

