/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.context;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.jboss.metadata.plugins.cache.Cache;
import org.jboss.metadata.plugins.cache.CacheFactory;
import org.jboss.metadata.plugins.cache.CacheItem;
import org.jboss.metadata.plugins.cache.DefaultCacheFactory;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.metadata.spi.signature.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingMetaDataContext
extends AbstractMetaDataContext {
    private volatile Cache<String, AnnotationItem> annotations;
    private volatile Cache<String, MetaDataItem> metaDataByName;
    private volatile CacheItem<AnnotationsItem> cachedAnnotationsItem;
    private volatile CacheItem<MetaDatasItem> cachedMetaDatasItem;
    private volatile Cache<Signature, MetaDataRetrieval> cachedComponents;
    private volatile long validTime;
    private volatile Boolean empty;
    private volatile Cache<ScopeLevel, MetaDataRetrieval> cachedScopedRetrievals;
    private CacheFactory factory;
    private String fqn;

    public CachingMetaDataContext(MetaDataRetrieval retrieval) {
        this(null, retrieval);
    }

    public CachingMetaDataContext(MetaDataRetrieval retrieval, CacheFactory factory) {
        this(null, retrieval, factory);
    }

    public CachingMetaDataContext(MetaDataContext parent, MetaDataRetrieval retrieval) {
        this(parent, Collections.singletonList(retrieval));
    }

    public CachingMetaDataContext(MetaDataContext parent, MetaDataRetrieval retrieval, CacheFactory factory) {
        this(parent, Collections.singletonList(retrieval), factory);
    }

    public CachingMetaDataContext(MetaDataContext parent, List<MetaDataRetrieval> retrievals) {
        this(parent, retrievals, null);
    }

    public CachingMetaDataContext(MetaDataContext parent, List<MetaDataRetrieval> retrievals, CacheFactory factory) {
        super(parent, retrievals);
        if (factory == null) {
            factory = new DefaultCacheFactory();
        }
        this.validTime = this.getValidTime().getValidTime();
        this.factory = factory;
        this.fqn = factory.createFqn(this);
    }

    protected String getFqn() {
        return this.fqn;
    }

    @Override
    public AnnotationsItem retrieveAnnotations() {
        AnnotationsItem item;
        if (this.cachedAnnotationsItem == null) {
            this.cachedAnnotationsItem = this.factory.createCacheItem(AnnotationsItem.class, this.getFqn());
        }
        if ((item = this.cachedAnnotationsItem.get()) == null) {
            item = super.retrieveAnnotations();
            this.cachedAnnotationsItem.put(item);
        }
        return item;
    }

    @Override
    public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType) {
        AnnotationItem result;
        if (annotationType == null) {
            throw new IllegalArgumentException("Null annotationType");
        }
        String annotationName = annotationType.getName();
        long newValidTime = this.getValidTime().getValidTime();
        if (this.validTime < newValidTime) {
            this.clearCache(this.annotations);
            this.clearCache(this.metaDataByName);
            this.validTime = newValidTime;
        }
        if (this.annotations != null && (result = this.annotations.get(annotationName)) != null) {
            if (result.isValid()) {
                return result;
            }
            this.annotations.remove(annotationName);
        }
        if ((result = super.retrieveAnnotation(annotationType)) != null && result.isCachable()) {
            if (this.annotations == null) {
                this.annotations = this.factory.createCache(String.class, AnnotationItem.class, this.getFqn());
            }
            this.annotations.put(annotationName, result);
        }
        return result;
    }

    @Override
    public MetaDatasItem retrieveMetaData() {
        MetaDatasItem item;
        if (this.cachedMetaDatasItem == null) {
            this.cachedMetaDatasItem = this.factory.createCacheItem(MetaDatasItem.class, this.getFqn());
        }
        if ((item = this.cachedMetaDatasItem.get()) == null) {
            item = super.retrieveMetaData();
            this.cachedMetaDatasItem.put(item);
        }
        return item;
    }

    @Override
    public <T> MetaDataItem<T> retrieveMetaData(Class<T> type) {
        MetaDataItem result;
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        String name = type.getName();
        long newValidTime = this.getValidTime().getValidTime();
        if (this.validTime < newValidTime) {
            this.clearCache(this.annotations);
            this.clearCache(this.metaDataByName);
            this.validTime = newValidTime;
        }
        if (this.metaDataByName != null && (result = this.metaDataByName.get(name)) != null) {
            if (result.isValid()) {
                return result;
            }
            this.metaDataByName.remove(name);
        }
        if ((result = super.retrieveMetaData(type)) != null && result.isCachable()) {
            if (this.metaDataByName == null) {
                this.metaDataByName = this.factory.createCache(String.class, MetaDataItem.class, this.getFqn());
            }
            this.metaDataByName.put(name, result);
        }
        return result;
    }

    @Override
    public MetaDataItem<?> retrieveMetaData(String name) {
        MetaDataItem result;
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        long newValidTime = this.getValidTime().getValidTime();
        if (this.validTime < newValidTime) {
            this.clearCache(this.annotations);
            this.clearCache(this.metaDataByName);
            this.validTime = newValidTime;
        }
        if (this.metaDataByName != null && (result = this.metaDataByName.get(name)) != null) {
            if (result.isValid()) {
                return result;
            }
            this.metaDataByName.remove(name);
        }
        if ((result = super.retrieveMetaData(name)) != null && result.isCachable()) {
            if (this.metaDataByName == null) {
                this.metaDataByName = this.factory.createCache(String.class, MetaDataItem.class, this.getFqn());
            }
            this.metaDataByName.put(name, result);
        }
        return result;
    }

    @Override
    public void append(MetaDataRetrieval retrieval) {
        super.append(retrieval);
        this.clearCache(this.cachedComponents);
        this.clearCache(this.cachedScopedRetrievals);
        this.empty = null;
    }

    @Override
    public void prepend(MetaDataRetrieval retrieval) {
        super.prepend(retrieval);
        this.clearCache(this.cachedComponents);
        this.clearCache(this.cachedScopedRetrievals);
        this.empty = null;
    }

    @Override
    public void remove(MetaDataRetrieval retrieval) {
        super.remove(retrieval);
        this.clearCache(this.cachedComponents);
        this.clearCache(this.cachedScopedRetrievals);
        this.empty = null;
    }

    @Override
    public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature) {
        MetaDataRetrieval retrieval;
        if (signature == null) {
            return null;
        }
        if (this.cachedComponents != null && (retrieval = this.cachedComponents.get(signature)) != null) {
            return retrieval;
        }
        retrieval = super.getComponentMetaDataRetrieval(signature);
        if (retrieval != null) {
            if (this.cachedComponents == null) {
                this.cachedComponents = this.factory.createCache(Signature.class, MetaDataRetrieval.class, this.getFqn());
            }
            this.cachedComponents.put(signature, retrieval);
        }
        return retrieval;
    }

    @Override
    public boolean isEmpty() {
        if (this.empty == null) {
            this.empty = super.isEmpty();
        }
        return this.empty;
    }

    @Override
    public MetaDataRetrieval getScopedRetrieval(ScopeLevel level) {
        MetaDataRetrieval retrieval;
        if (level == null) {
            return null;
        }
        if (this.cachedScopedRetrievals != null && (retrieval = this.cachedScopedRetrievals.get(level)) != null) {
            return retrieval;
        }
        retrieval = super.getScopedRetrieval(level);
        if (retrieval != null) {
            if (this.cachedScopedRetrievals == null) {
                this.cachedScopedRetrievals = this.factory.createCache(ScopeLevel.class, MetaDataRetrieval.class, this.getFqn());
            }
            this.cachedScopedRetrievals.put(level, retrieval);
        }
        return retrieval;
    }

    protected void clearCache(Cache<?, ?> cache) {
        if (cache != null) {
            cache.clear();
        }
    }
}

