/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;
import org.jboss.jms.message.JBossStreamMessage;
import org.jboss.jms.message.MessageProxy;

public class StreamMessageProxy
extends MessageProxy
implements StreamMessage {
    private static final long serialVersionUID = 856367553964704474L;

    public StreamMessageProxy(long deliveryId, JBossStreamMessage message, int deliveryCount) {
        super(deliveryId, message, deliveryCount);
    }

    public StreamMessageProxy(JBossStreamMessage message) {
        super(message);
    }

    public StreamMessageProxy(StreamMessageProxy proxy) throws JMSException {
        super(proxy);
    }

    public boolean readBoolean() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readBoolean();
    }

    public byte readByte() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readByte();
    }

    public int readBytes(byte[] value) throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readBytes(value);
    }

    public char readChar() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readChar();
    }

    public double readDouble() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readDouble();
    }

    public float readFloat() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readFloat();
    }

    public int readInt() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readInt();
    }

    public long readLong() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readLong();
    }

    public Object readObject() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readObject();
    }

    public short readShort() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readShort();
    }

    public String readString() throws JMSException {
        if (!this.bodyReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        return ((StreamMessage)this.message).readString();
    }

    public void reset() throws JMSException {
        this.bodyReadOnly = true;
        ((StreamMessage)this.message).reset();
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeByte(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeBytes(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeBytes(value, offset, length);
    }

    public void writeChar(char value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeChar(value);
    }

    public void writeDouble(double value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeDouble(value);
    }

    public void writeFloat(float value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeFloat(value);
    }

    public void writeInt(int value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeLong(value);
    }

    public void writeObject(Object value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeObject(value);
    }

    public void writeShort(short value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeShort(value);
    }

    public void writeString(String value) throws JMSException {
        if (this.bodyReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.bodyChange();
        ((StreamMessage)this.message).writeString(value);
    }

    public MessageProxy duplicate() throws JMSException {
        return new StreamMessageProxy(this);
    }
}

