#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

. $XB_BUILD_DIR/xb.functions.sh

mmod=$1
$XB_VERBOSE "Making jakarta-commons-daemon..."
if [ ".$mmod" = .B ]; then
    srcd=brew
    if [ -d $srcd ]; then
        cd $srcd
        install -m 755 -d "$XB_BUILD_ROOT$o_prefix/$libd"
        xbcopypdir usr/share/java "$XB_BUILD_ROOT$o_prefix/$libd"
        xbcopypdir usr/share/javadoc "$XB_BUILD_ROOT$o_prefix/doc/javadoc"
        xbcopypdir usr/share/doc "$XB_BUILD_ROOT$o_prefix/doc"
    else
        exit 2
    fi
else
    if [ -f skip.makefiles ]; then
        $XB_VERBOSE "Skipping make stage"
        exit 0
    fi
    if [ -f sources ]; then
        srcd=`cat sources | head -n 1`
        if [ ".$srcd" = . ]; then
            exit 22
        fi
        if [ -d "$srcd/src/native/unix" ]; then
            $XB_VERBOSE "Making jsvc..."
            $XB_VERBOSE "  prefix      : \`$o_prefix'"
            $XB_VERBOSE "  rpm options : $RPM_OPT_FLAGS"
            $XB_VERBOSE "  arch        : $arch-bit"
            $XB_VERBOSE ""
            cd "$srcd/src/native/unix"
            bldn=`pwd`
            (
                cd native
                make all
            )
            if [ -f jsvc ]; then
                xbstripbin jsvc
                install -m 755 jsvc "$XB_BUILD_ROOT$o_prefix/$sbin/"
                cd "$XB_BUILD_ROOT$o_prefix/sbin/"
                if [ $XB_BUILD_BIT -eq 64 ]; then
                    for i in jsvc
                    do
                        xbmakelnk $arch/$i $i
                    done
                    cd $arch
                fi
            else
                echo "ERROR: jsvc not made"
                exit 2
            fi
        else
            exit 20
        fi
    else
        exit 2
    fi
fi

exit 0

