#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

# Common runtime variables
xb_prognam=`basename $0`
xb_dirname=`dirname $0`

xb_at_exit_del=""
xb_at_exit_run=""
xb_at_exit_exe=""

# String constants
XB_TAB="	"
XB_LF="
"

xb_setup_verbose()
{
    XB_VERBOSE=:
    if [ -x /usr/ucb/echo ]; then
        XB_ECHO=/usr/ucb/echo
    else
        XB_ECHO=echo
    fi
    if [ ".$xb_verbose" = . ]; then
        xb_verbose=false;
    else
        XB_VERBOSE=$XB_ECHO
    fi
    export xb_verbose
    export XB_ECHO
    export XB_VERBOSE
}

# Remove registered files on exit()
xb_at_exit()
{
    o_del=false
    o_run=false
    o_exe=false
    for o
    do
        case "$o" in
        -*=*) a=`echo "$o" | sed 's/^[-_a-zA-Z0-9]*=//'` ;;
           *) a='' ;;
        esac
        case "$o" in
            -d|--del*    ) o_del=true;      shift ;;
            -r|--run     ) o_run=true;      shift ;;
            -e|--exe*    ) o_exe=true;      shift ;;
            *  ) break ;;
        esac
    done

    if $o_del; then
        xb_at_exit_del="$1 $xb_at_exit_del"
    elif $o_run; then
        xb_at_exit_run="$1 $xb_at_exit_run"
    elif $o_exe; then
        xb_at_exit_exe="$1 $xb_at_exit_exe"
    fi
}

xb_exit()
{
    r=$1
    for i in $xb_at_exit_del
    do
        $XB_VERBOSE "Removing      : $i"
        rm -rf $i 2>/dev/null || true
    done
    for i in $xb_at_exit_run
    do
        $XB_VERBOSE "Running       : $i"
        eval $i
    done
    for i in $xb_at_exit_exe
    do
        $XB_VERBOSE "Executing     : $i"
        exec $i
    done
    $XB_VERBOSE ""
    $XB_VERBOSE "Exiting       : $xb_prognam"
    $XB_VERBOSE ""
    $XB_VERBOSE "Ended         : `date`"
    $XB_VERBOSE "Return        : $r"
    $XB_VERBOSE ""
    exit $r
}

xb_setup_verbose

xb_progloc="`cd \"$xb_dirname\" && pwd`"
export xb_progloc

XB_SCRIPT_LOC="$xb_progloc"
export XB_SCRIPT_LOC
export XB_TAB
export XB_LF
