/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.DeserializerSupport;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.extensions.xop.jaxrpc.XOPUnmarshallerImpl;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Base64Deserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger(Base64Deserializer.class);

    public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
        return this.deserialize(xmlName, xmlType, this.sourceToElement(xmlFragment), serContext);
    }

    private Object deserialize(QName xmlName, QName xmlType, Element xmlFragment, SerializationContext serContext) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        }
        byte[] value = null;
        if (XOPContext.isXOPMessage()) {
            Element xopInclude = DOMUtils.getFirstChildElement((Node)xmlFragment);
            String cid = xopInclude.getAttribute("href");
            XOPUnmarshallerImpl xopUnmarshaller = new XOPUnmarshallerImpl();
            value = xopUnmarshaller.getAttachmentAsByteArray(cid);
        } else {
            String valueStr = this.unwrapValueStr(xmlFragment);
            if (valueStr != null) {
                value = SimpleTypeBindings.unmarshalBase64((String)valueStr);
            }
        }
        return value;
    }
}

