/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.cluster;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.UEncoder;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;
import org.jboss.web.cluster.JSSESocketFactory;
import org.jboss.web.cluster.advertise.AdvertiseListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterListener
implements LifecycleListener,
ContainerListener {
    protected static Logger log = Logger.getLogger(ClusterListener.class);
    protected StringManager sm = StringManager.getManager("org.jboss.web.cluster");
    protected UEncoder encoder = new UEncoder();
    protected ObjectName oname;
    protected Proxy[] proxies = new Proxy[0];
    protected JSSESocketFactory sslSocketFactory = null;
    protected Socket[] connections = null;
    protected BufferedReader[] connectionReaders = null;
    protected BufferedWriter[] connectionWriters = null;
    protected boolean init = false;
    protected ArrayList<Proxy> addProxies = new ArrayList();
    protected ArrayList<Proxy> removeProxies = new ArrayList();
    protected AdvertiseListener listener = null;
    protected int advertise = -1;
    protected String advertiseGroupAddress = null;
    protected int advertisePort = -1;
    protected String advertiseSecurityKey = null;
    protected String proxyList = null;
    protected String proxyURL = null;
    protected int socketTimeout = 20000;
    protected String domain = null;
    protected boolean flushPackets = false;
    protected int flushWait = -1;
    protected int ping = -1;
    protected int smax = -1;
    protected int ttl = -1;
    protected int nodeTimeout = -1;
    protected String balancer = null;
    protected boolean stickySession = true;
    protected boolean stickySessionRemove = false;
    protected boolean stickySessionForce = true;
    protected int workerTimeout = -1;
    protected int maxAttempts = -1;
    protected boolean ssl = false;
    protected String sslCiphers = null;
    protected String sslProtocol = "TLS";
    protected String sslCertificateEncodingAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    protected String sslKeyStore = System.getProperty("user.home") + "/.keystore";
    protected String sslKeyStorePass = "changeit";
    protected String sslKeyStoreType = "JKS";
    protected String sslKeyStoreProvider = null;
    protected String sslTrustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    protected String sslKeyAlias = null;
    protected String sslCrlFile = null;
    protected int sslTrustMaxCertLength = 5;
    protected String sslTrustStore = System.getProperty("javax.net.ssl.trustStore");
    protected String sslTrustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
    protected String sslTrustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
    protected String sslTrustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");

    public boolean getAdvertise() {
        return this.advertise != 0;
    }

    public void setAdvertise(boolean advertise) {
        this.advertise = advertise ? 1 : 0;
    }

    public String getAdvertiseGroupAddress() {
        return this.advertiseGroupAddress;
    }

    public void setAdvertiseGroupAddress(String advertiseGroupAddress) {
        this.advertiseGroupAddress = advertiseGroupAddress;
    }

    public int getAdvertisePort() {
        return this.advertisePort;
    }

    public void setAdvertisePort(int advertisePort) {
        this.advertisePort = advertisePort;
    }

    public String getAdvertiseSecurityKey() {
        return this.advertiseSecurityKey;
    }

    public void setAdvertiseSecurityKey(String advertiseSecurityKey) {
        this.advertiseSecurityKey = advertiseSecurityKey;
    }

    public String getProxyList() {
        return this.proxyList;
    }

    public void setProxyList(String proxyList) {
        this.proxyList = proxyList;
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public void setProxyURL(String proxyURL) {
        this.proxyURL = proxyURL;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean getFlushPackets() {
        return this.flushPackets;
    }

    public void setFlushPackets(boolean flushPackets) {
        this.flushPackets = flushPackets;
    }

    public int getFlushWait() {
        return this.flushWait;
    }

    public void setFlushWait(int flushWait) {
        this.flushWait = flushWait;
    }

    public int getPing() {
        return this.ping;
    }

    public void setPing(int ping) {
        this.ping = ping;
    }

    public int getSmax() {
        return this.smax;
    }

    public void setSmax(int smax) {
        this.smax = smax;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public int getNodeTimeout() {
        return this.nodeTimeout;
    }

    public void setNodeTimeout(int nodeTimeout) {
        this.nodeTimeout = nodeTimeout;
    }

    public String getBalancer() {
        return this.balancer;
    }

    public void setBalancer(String balancer) {
        this.balancer = balancer;
    }

    public boolean getStickySession() {
        return this.stickySession;
    }

    public void setStickySession(boolean stickySession) {
        this.stickySession = stickySession;
    }

    public boolean getStickySessionRemove() {
        return this.stickySessionRemove;
    }

    public void setStickySessionRemove(boolean stickySessionRemove) {
        this.stickySessionRemove = stickySessionRemove;
    }

    public boolean getStickySessionForce() {
        return this.stickySessionForce;
    }

    public void setStickySessionForce(boolean stickySessionForce) {
        this.stickySessionForce = stickySessionForce;
    }

    public int getWorkerTimeout() {
        return this.workerTimeout;
    }

    public void setWorkerTimeout(int workerTimeout) {
        this.workerTimeout = workerTimeout;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getSslCiphers() {
        return this.sslCiphers;
    }

    public void setSslCiphers(String sslCiphers) {
        this.sslCiphers = sslCiphers;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getSslCertificateEncodingAlgorithm() {
        return this.sslCertificateEncodingAlgorithm;
    }

    public void setSslCertificateEncodingAlgorithm(String sslCertificateEncodingAlgorithm) {
        this.sslCertificateEncodingAlgorithm = sslCertificateEncodingAlgorithm;
    }

    public String getSslKeyStore() {
        return this.sslKeyStore;
    }

    public void setSslKeyStore(String sslKeyStore) {
        this.sslKeyStore = sslKeyStore;
    }

    public String getSslKeyStorePass() {
        return this.sslKeyStorePass;
    }

    public void setSslKeyStorePass(String sslKeyStorePass) {
        this.sslKeyStorePass = sslKeyStorePass;
    }

    public String getSslKeyStoreType() {
        return this.sslKeyStoreType;
    }

    public void setSslKeyStoreType(String sslKeyStoreType) {
        this.sslKeyStoreType = sslKeyStoreType;
    }

    public String getSslKeyStoreProvider() {
        return this.sslKeyStoreProvider;
    }

    public void setSslKeyStoreProvider(String sslKeyStoreProvider) {
        this.sslKeyStoreProvider = sslKeyStoreProvider;
    }

    public String getSslTrustAlgorithm() {
        return this.sslTrustAlgorithm;
    }

    public void setSslTrustAlgorithm(String sslTrustAlgorithm) {
        this.sslTrustAlgorithm = sslTrustAlgorithm;
    }

    public String getSslKeyAlias() {
        return this.sslKeyAlias;
    }

    public void setSslKeyAlias(String sslKeyAlias) {
        this.sslKeyAlias = sslKeyAlias;
    }

    public String getSslCrlFile() {
        return this.sslCrlFile;
    }

    public void setSslCrlFile(String sslCrlFile) {
        this.sslCrlFile = sslCrlFile;
    }

    public int getSslTrustMaxCertLength() {
        return this.sslTrustMaxCertLength;
    }

    public void setSslTrustMaxCertLength(int sslTrustMaxCertLength) {
        this.sslTrustMaxCertLength = sslTrustMaxCertLength;
    }

    public String getSslTrustStore() {
        return this.sslTrustStore;
    }

    public void setSslTrustStore(String sslTrustStore) {
        this.sslTrustStore = sslTrustStore;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public void setSslTrustStorePassword(String sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
    }

    public String getSslTrustStoreType() {
        return this.sslTrustStoreType;
    }

    public void setSslTrustStoreType(String sslTrustStoreType) {
        this.sslTrustStoreType = sslTrustStoreType;
    }

    public String getSslTrustStoreProvider() {
        return this.sslTrustStoreProvider;
    }

    public void setSslTrustStoreProvider(String sslTrustStoreProvider) {
        this.sslTrustStoreProvider = sslTrustStoreProvider;
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        Object child = event.getData();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).addLifecycleListener(this);
                this.addContext((Context)child, -1);
            } else if (container instanceof Engine) {
                container.addContainerListener(this);
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).removeLifecycleListener(this);
                this.removeContext((Context)child, -1);
            } else if (container instanceof Engine) {
                container.removeContainerListener(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        if ("start".equals(event.getType())) {
            if (!(source instanceof Context)) return;
            this.startContext((Context)((Object)source), -1);
            return;
        }
        if ("after_start".equals(event.getType())) {
            if (!(source instanceof Server)) return;
            if (this.proxyList == null) {
                if (this.advertise != 0) {
                    this.proxies = new Proxy[0];
                    this.startListener();
                } else {
                    this.proxies = new Proxy[1];
                    this.proxies[0] = new Proxy();
                }
            } else {
                ArrayList<Proxy> proxyList = new ArrayList<Proxy>();
                StringTokenizer tok = new StringTokenizer(this.proxyList, ",");
                while (tok.hasMoreTokens()) {
                    Proxy proxy;
                    block20: {
                        String token = tok.nextToken().trim();
                        proxy = new Proxy();
                        int pos = token.indexOf(58);
                        String address = null;
                        if (pos < 0) {
                            address = token;
                        } else if (pos == 0) {
                            address = null;
                            proxy.port = Integer.parseInt(token.substring(1));
                        } else {
                            address = token.substring(0, pos);
                            proxy.port = Integer.parseInt(token.substring(pos + 1));
                        }
                        try {
                            if (address == null) break block20;
                            proxy.address = InetAddress.getByName(address);
                        }
                        catch (Exception e) {
                            log.error((Object)this.sm.getString("clusterListener.error.invalidHost", address), (Throwable)e);
                            continue;
                        }
                    }
                    proxyList.add(proxy);
                }
                this.proxies = proxyList.toArray(new Proxy[0]);
            }
            this.connections = new Socket[this.proxies.length];
            this.connectionReaders = new BufferedReader[this.proxies.length];
            this.connectionWriters = new BufferedWriter[this.proxies.length];
            this.sslInit();
            this.startServer((Server)((Object)source), -1);
            if (this.advertise == 1) {
                this.startListener();
            }
            this.init = true;
            return;
        }
        if ("stop".equals(event.getType())) {
            if (source instanceof Context) {
                this.stopContext((Context)((Object)source), -1);
                return;
            } else {
                if (!(source instanceof Server)) return;
                this.stopListener();
                this.stopServer((Server)((Object)source), -1);
                if (this.connections != null) {
                    for (int i = 0; i < this.connections.length; ++i) {
                        this.closeConnection(i);
                    }
                }
                this.init = false;
            }
            return;
        } else {
            if (!"periodic".equals(event.getType()) || !this.init || !(source instanceof Engine)) return;
            this.status((Engine)((Object)source));
        }
    }

    public void addProxy(String address) {
        int pos = address.indexOf(58);
        String host = null;
        int port = 0;
        if (pos < 0) {
            host = address;
        } else if (pos == 0) {
            host = null;
            port = Integer.parseInt(address.substring(1));
        } else {
            host = address.substring(0, pos);
            port = Integer.parseInt(address.substring(pos + 1));
        }
        this.addProxy(host, port);
    }

    public synchronized void addProxy(String host, int port) {
        Proxy proxy = new Proxy();
        try {
            proxy.address = InetAddress.getByName(host);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (port > 0) {
            proxy.port = port;
        }
        proxy.state = State.ERROR;
        this.addProxies.add(proxy);
    }

    public synchronized void removeProxy(String host, int port) {
        Proxy proxy = new Proxy();
        try {
            proxy.address = InetAddress.getByName(host);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (port > 0) {
            proxy.port = port;
        }
        this.removeProxies.add(proxy);
    }

    public String getProxyConfiguration() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Proxy[] local = this.proxies;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < local.length; ++i) {
            result.append("Proxy[").append(i).append("]: [").append(local[i].address).append(':').append(local[i].port).append("]: \r\n");
            result.append(this.sendRequest("DUMP", true, parameters, i));
            result.append("\r\n");
        }
        return result.toString();
    }

    public String getProxyInfo() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Proxy[] local = this.proxies;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < local.length; ++i) {
            result.append("Proxy[").append(i).append("]: [").append(local[i].address).append(':').append(local[i].port).append("]: \r\n");
            result.append(this.sendRequest("INFO", true, parameters, i));
            result.append("\r\n");
        }
        return result.toString();
    }

    public String doProxyPing(String JvmRoute) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (JvmRoute != null) {
            parameters.put("JVMRoute", JvmRoute);
        }
        Proxy[] local = this.proxies;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < local.length; ++i) {
            result.append("Proxy[").append(i).append("]: [").append(local[i].address).append(':').append(local[i].port).append("]: \r\n");
            result.append(this.sendRequest("PING", true, parameters, i));
            result.append("\r\n");
        }
        return result.toString();
    }

    public String doProxyPing(String scheme, String host, int port) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (scheme != null) {
            parameters.put("Scheme", scheme);
        }
        if (host != null) {
            parameters.put("Host", host);
        }
        if (port != 0) {
            parameters.put("Port", String.valueOf(port));
        }
        Proxy[] local = this.proxies;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < local.length; ++i) {
            result.append("Proxy[").append(i).append("]: [").append(local[i].address).append(':').append(local[i].port).append("]: \r\n");
            result.append(this.sendRequest("PING", true, parameters, i));
            result.append("\r\n");
        }
        return result.toString();
    }

    public void reset() {
        Proxy[] local = this.proxies;
        for (int i = 0; i < local.length; ++i) {
            if (local[i].state != State.DOWN) continue;
            local[i].state = State.ERROR;
        }
    }

    public void refresh() {
        Proxy[] local = this.proxies;
        for (int i = 0; i < local.length; ++i) {
            if (local[i].state != State.OK) continue;
            local[i].state = State.ERROR;
        }
    }

    public boolean disable() {
        Service[] services = ServerFactory.getServer().findServices();
        for (int i = 0; i < services.length; ++i) {
            Engine engine = (Engine)services[i].getContainer();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("JVMRoute", engine.getJvmRoute());
            this.sendRequest("DISABLE-APP", true, parameters);
        }
        return this.proxies[0].state == State.OK;
    }

    public boolean enable() {
        Service[] services = ServerFactory.getServer().findServices();
        for (int i = 0; i < services.length; ++i) {
            Engine engine = (Engine)services[i].getContainer();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("JVMRoute", engine.getJvmRoute());
            this.sendRequest("ENABLE-APP", true, parameters);
        }
        return this.proxies[0].state == State.OK;
    }

    protected void startListener() {
        this.listener = new AdvertiseListener(this);
        if (this.advertiseGroupAddress != null) {
            this.listener.setGroupAddress(this.advertiseGroupAddress);
        }
        if (this.advertisePort > 0) {
            this.listener.setAdvertisePort(this.advertisePort);
        }
        try {
            if (this.advertiseSecurityKey != null) {
                this.listener.setSecurityKey(this.advertiseSecurityKey);
            }
            this.listener.start();
        }
        catch (IOException e) {
            log.error((Object)this.sm.getString("clusterListener.error.startListener"), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)this.sm.getString("clusterListener.error.startListener"), (Throwable)e);
        }
    }

    protected void stopListener() {
        if (this.listener != null) {
            try {
                this.listener.destroy();
            }
            catch (IOException e) {
                log.error((Object)this.sm.getString("clusterListener.error.stopListener"), (Throwable)e);
            }
            this.listener = null;
        }
    }

    protected void startServer(Server server, int pos) {
        if (this.oname == null) {
            try {
                this.oname = new ObjectName(((StandardServer)server).getDomain() + ":type=ClusterListener");
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                log.error((Object)this.sm.getString("clusterListener.error.jmxRegister"), (Throwable)e);
            }
        }
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            services[i].getContainer().addContainerListener(this);
            Engine engine = (Engine)services[i].getContainer();
            ((Lifecycle)((Object)engine)).addLifecycleListener(this);
            Connector connector = this.findProxyConnector(engine.getService().findConnectors());
            InetAddress localAddress = (InetAddress)IntrospectionUtils.getProperty(connector.getProtocolHandler(), "address");
            if ((engine.getJvmRoute() == null || localAddress == null) && this.proxies.length > 0) {
                try {
                    if (localAddress == null) {
                        Socket connection = this.getConnection(0);
                        localAddress = connection.getLocalAddress();
                        if (localAddress != null) {
                            IntrospectionUtils.setProperty(connector.getProtocolHandler(), "address", localAddress.getHostAddress());
                        } else {
                            IntrospectionUtils.setProperty(connector.getProtocolHandler(), "address", "127.0.0.1");
                        }
                        log.info((Object)this.sm.getString("clusterListener.address", localAddress.getHostAddress()));
                    }
                    if (engine.getJvmRoute() == null) {
                        String hostName = null;
                        hostName = localAddress != null ? localAddress.getHostName() : "127.0.0.1";
                        String jvmRoute = hostName + ":" + connector.getPort() + ":" + engine.getName();
                        engine.setJvmRoute(jvmRoute);
                        log.info((Object)this.sm.getString("clusterListener.jvmRoute", engine.getName(), jvmRoute));
                    }
                }
                catch (Exception e) {
                    this.proxies[0].state = State.ERROR;
                    log.info((Object)this.sm.getString("clusterListener.error.addressJvmRoute"), (Throwable)e);
                    return;
                }
            }
            this.config(engine, pos);
            Container[] children = engine.findChildren();
            for (int j = 0; j < children.length; ++j) {
                children[j].addContainerListener(this);
                Container[] children2 = children[j].findChildren();
                for (int k = 0; k < children2.length; ++k) {
                    ((Lifecycle)((Object)children2[k])).addLifecycleListener(this);
                    this.addContext((Context)children2[k], pos);
                }
            }
        }
    }

    protected void stopServer(Server server, int pos) {
        if (this.oname == null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            catch (Exception e) {
                log.error((Object)this.sm.getString("clusterListener.error.jmxUnregister"), (Throwable)e);
            }
        }
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            services[i].getContainer().removeContainerListener(this);
            ((Lifecycle)((Object)services[i].getContainer())).removeLifecycleListener(this);
            this.removeAll((Engine)services[i].getContainer(), pos);
            Container[] children = services[i].getContainer().findChildren();
            for (int j = 0; j < children.length; ++j) {
                children[j].removeContainerListener(this);
                Container[] children2 = children[j].findChildren();
                for (int k = 0; k < children2.length; ++k) {
                    ((Lifecycle)((Object)children2[k])).removeLifecycleListener(this);
                    this.removeContext((Context)children2[k], pos);
                }
            }
        }
    }

    protected void reset(int pos) {
        Service[] services = ServerFactory.getServer().findServices();
        for (int i = 0; i < services.length; ++i) {
            Engine engine = (Engine)services[i].getContainer();
            this.removeAll((Engine)services[i].getContainer(), pos);
            this.config(engine, pos);
            Container[] children = engine.findChildren();
            for (int j = 0; j < children.length; ++j) {
                Container[] children2 = children[j].findChildren();
                for (int k = 0; k < children2.length; ++k) {
                    this.addContext((Context)children2[k], pos);
                }
            }
        }
    }

    protected void config(Engine engine, int pos) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("clusterListener.config", engine.getName()));
        }
        Connector connector = this.findProxyConnector(engine.getService().findConnectors());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", engine.getJvmRoute());
        boolean reverseConnection = Boolean.TRUE.equals(IntrospectionUtils.getProperty(connector.getProtocolHandler(), "reverseConnection"));
        boolean ssl = Boolean.TRUE.equals(IntrospectionUtils.getProperty(connector.getProtocolHandler(), "SSLEnabled"));
        boolean ajp = ((String)IntrospectionUtils.getProperty(connector.getProtocolHandler(), "name")).startsWith("ajp-");
        if (reverseConnection) {
            parameters.put("Reversed", "true");
        }
        parameters.put("Host", this.getAddress(connector));
        parameters.put("Port", "" + connector.getPort());
        if (ajp) {
            parameters.put("Type", "ajp");
        } else if (ssl) {
            parameters.put("Type", "https");
        } else {
            parameters.put("Type", "http");
        }
        if (this.domain != null) {
            parameters.put("Domain", this.domain);
        }
        if (this.flushPackets) {
            parameters.put("flushpackets", "On");
        }
        if (this.flushWait != -1) {
            parameters.put("flushwait", "" + this.flushWait);
        }
        if (this.ping != -1) {
            parameters.put("ping", "" + this.ping);
        }
        if (this.smax != -1) {
            parameters.put("smax", "" + this.smax);
        }
        if (this.ttl != -1) {
            parameters.put("ttl", "" + this.ttl);
        }
        if (this.nodeTimeout != -1) {
            parameters.put("Timeout", "" + this.nodeTimeout);
        }
        if (this.balancer != null) {
            parameters.put("Balancer", this.balancer);
        }
        if (!this.stickySession) {
            parameters.put("StickySession", "No");
        }
        if (!Globals.SESSION_COOKIE_NAME.equals("JSESSIONID")) {
            parameters.put("StickySessionCookie", Globals.SESSION_COOKIE_NAME);
        }
        if (!Globals.SESSION_PARAMETER_NAME.equals("jsessionid")) {
            parameters.put("StickySessionPath", Globals.SESSION_PARAMETER_NAME);
        }
        if (this.stickySessionRemove) {
            parameters.put("StickSessionRemove", "Yes");
        }
        if (!this.stickySessionForce) {
            parameters.put("StickySessionForce", "No");
        }
        if (this.workerTimeout != -1) {
            parameters.put("WaitWorker", "" + this.workerTimeout);
        }
        if (this.maxAttempts != -1) {
            parameters.put("Maxattempts", "" + this.maxAttempts);
        }
        this.sendRequest("CONFIG", false, parameters, pos);
    }

    protected void removeAll(Engine engine, int pos) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("clusterListener.stop", engine.getName()));
        }
        if (engine.getJvmRoute() != null) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("JVMRoute", engine.getJvmRoute());
            this.sendRequest("REMOVE-APP", true, parameters, pos);
        }
    }

    protected synchronized void status(Engine engine) {
        int i;
        if (!this.addProxies.isEmpty() || !this.removeProxies.isEmpty()) {
            ArrayList<Proxy> currentProxies = new ArrayList<Proxy>();
            for (i = 0; i < this.proxies.length; ++i) {
                currentProxies.add(this.proxies[i]);
            }
            for (i = 0; i < this.addProxies.size(); ++i) {
                if (currentProxies.contains(this.addProxies.get(i))) continue;
                currentProxies.add(this.addProxies.get(i));
            }
            for (i = 0; i < this.removeProxies.size(); ++i) {
                if (!currentProxies.contains(this.removeProxies.get(i))) continue;
                currentProxies.remove(this.removeProxies.get(i));
            }
            this.addProxies.clear();
            this.removeProxies.clear();
            this.proxies = currentProxies.toArray(new Proxy[0]);
            if (this.connections != null) {
                for (i = 0; i < this.connections.length; ++i) {
                    this.closeConnection(i);
                }
            }
            this.connections = new Socket[this.proxies.length];
            this.connectionReaders = new BufferedReader[this.proxies.length];
            this.connectionWriters = new BufferedWriter[this.proxies.length];
        }
        Proxy[] local = this.proxies;
        for (i = 0; i < local.length; ++i) {
            if (local[i].state == State.ERROR) {
                local[i].state = State.OK;
                this.reset(i);
                continue;
            }
            if (local[i].state != State.OK) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)this.sm.getString("clusterListener.status", engine.getName()));
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("JVMRoute", engine.getJvmRoute());
            parameters.put("Load", "1");
            this.sendRequest("STATUS", false, parameters, i);
        }
    }

    protected void addContext(Context context, int pos) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("clusterListener.context.enable", context.getPath(), context.getParent().getName(), ((StandardContext)context).getState()));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("Context", "".equals(context.getPath()) ? "/" : context.getPath());
        parameters.put("Alias", this.getHost(context));
        if (context.isStarted()) {
            this.sendRequest("ENABLE-APP", false, parameters, pos);
        }
    }

    protected void removeContext(Context context, int pos) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("clusterListener.context.disable", context.getPath(), context.getParent().getName(), ((StandardContext)context).getState()));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        String jvmRoute = this.getJvmRoute(context);
        if (jvmRoute != null) {
            parameters.put("JVMRoute", jvmRoute);
            parameters.put("Context", "".equals(context.getPath()) ? "/" : context.getPath());
            parameters.put("Alias", this.getHost(context));
            this.sendRequest("REMOVE-APP", false, parameters, pos);
        }
    }

    protected void startContext(Context context, int pos) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("clusterListener.context.start", context.getPath(), context.getParent().getName()));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("Context", "".equals(context.getPath()) ? "/" : context.getPath());
        parameters.put("Alias", this.getHost(context));
        this.sendRequest("ENABLE-APP", false, parameters, pos);
    }

    protected void stopContext(Context context, int pos) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("clusterListener.context.stop", context.getPath(), context.getParent().getName()));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("Context", "".equals(context.getPath()) ? "/" : context.getPath());
        parameters.put("Alias", this.getHost(context));
        this.sendRequest("STOP-APP", false, parameters, pos);
    }

    protected String getJvmRoute(Context context) {
        return ((Engine)context.getParent().getParent()).getJvmRoute();
    }

    protected String getHost(Context context) {
        StringBuffer result = new StringBuffer();
        Host host = (Host)context.getParent();
        result.append(host.getName());
        String[] aliases = host.findAliases();
        for (int i = 0; i < aliases.length; ++i) {
            result.append(',');
            result.append(aliases[i]);
        }
        return result.toString();
    }

    protected Connector findProxyConnector(Connector[] connectors) {
        int pos = 0;
        int maxThreads = 0;
        for (int i = 0; i < connectors.length; ++i) {
            if (connectors[i].getProtocol().startsWith("AJP")) {
                return connectors[i];
            }
            if (Boolean.TRUE.equals(IntrospectionUtils.getProperty(connectors[i].getProtocolHandler(), "reverseConnection"))) {
                return connectors[i];
            }
            Integer mt = (Integer)IntrospectionUtils.getProperty(connectors[i].getProtocolHandler(), "maxThreads");
            if (mt <= maxThreads) continue;
            maxThreads = mt;
            pos = i;
        }
        return connectors[pos];
    }

    protected String getAddress(Connector connector) {
        InetAddress inetAddress = (InetAddress)IntrospectionUtils.getProperty(connector.getProtocolHandler(), "address");
        if (inetAddress == null) {
            return "127.0.0.1";
        }
        return inetAddress.getHostAddress();
    }

    protected void sendRequest(String command, boolean wildcard, HashMap<String, String> parameters) {
        this.sendRequest(command, wildcard, parameters, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized String sendRequest(String command, boolean wildcard, HashMap<String, String> parameters, int pos) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        CharChunk body = null;
        try {
            body = this.encoder.encodeURL("", 0, 0);
            body.recycle();
            Iterator<String> keys = parameters.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                String value = parameters.get(key);
                if (value == null) {
                    throw new IllegalArgumentException(this.sm.getString("clusterListener.error.nullAttribute", key));
                }
                body = this.encoder.encodeURL(key, 0, key.length());
                body.append('=');
                if (value != null) {
                    body = this.encoder.encodeURL(value, 0, value.length());
                }
                if (!keys.hasNext()) continue;
                body.append('&');
            }
        }
        catch (IOException e) {
            body.recycle();
            throw new IllegalArgumentException(e);
        }
        int start = 0;
        int end = this.proxies.length;
        if (pos != -1) {
            start = pos;
            end = pos + 1;
        }
        int i = start;
        while (i < end) {
            if (this.proxies[i].state == State.OK) {
                Object var24_32;
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.sm.getString("clusterListener.request", command, wildcard, this.proxies[i]));
                }
                try {
                    block40: {
                        try {
                            this.getConnection(i);
                            writer = this.getConnectionWriter(i);
                            try {
                                writer.write("\r\n");
                                writer.flush();
                            }
                            catch (IOException e) {
                                this.closeConnection(i);
                                this.getConnection(i);
                                writer = this.getConnectionWriter(i);
                            }
                            String url = this.proxyURL;
                            if (url == null) {
                                url = wildcard ? "/*" : "/";
                            } else if (url.endsWith("/") && wildcard) {
                                url = url + "*";
                            } else if (wildcard) {
                                url = url + "/*";
                            }
                            String requestLine = command + " " + url + " HTTP/1.0";
                            writer.write(requestLine);
                            writer.write("\r\n");
                            writer.write("Content-Length: " + body.getLength() + "\r\n");
                            writer.write("User-Agent: ClusterListener/1.0\r\n");
                            writer.write("Connection: Keep-Alive\r\n");
                            writer.write("\r\n");
                            writer.write(body.getBuffer(), body.getStart(), body.getLength());
                            writer.write("\r\n");
                            writer.flush();
                            reader = this.getConnectionReader(i);
                            String responseStatus = reader.readLine();
                            int status = 500;
                            String version = "0";
                            String message = null;
                            String errorType = null;
                            int contentLength = 0;
                            if (responseStatus != null) {
                                try {
                                    responseStatus = responseStatus.substring(responseStatus.indexOf(32) + 1, responseStatus.indexOf(32, responseStatus.indexOf(32) + 1));
                                    status = Integer.parseInt(responseStatus);
                                    String header = reader.readLine();
                                    while (!"".equals(header)) {
                                        int colon = header.indexOf(58);
                                        String headerName = header.substring(0, colon).trim();
                                        String headerValue = header.substring(colon + 1).trim();
                                        if ("version".equalsIgnoreCase(headerName)) {
                                            version = headerValue;
                                        } else if ("type".equalsIgnoreCase(headerName)) {
                                            errorType = headerValue;
                                        } else if ("mess".equalsIgnoreCase(headerName)) {
                                            message = headerValue;
                                        } else if ("content-length".equalsIgnoreCase(headerName)) {
                                            contentLength = Integer.parseInt(headerValue);
                                        }
                                        header = reader.readLine();
                                    }
                                }
                                catch (Exception e) {
                                    log.info((Object)this.sm.getString("clusterListener.error.parse", command), (Throwable)e);
                                }
                            }
                            if (status == 200) {
                                StringBuffer result = new StringBuffer();
                                if (contentLength > 0) {
                                    int n;
                                    int thisTime = contentLength;
                                    char[] buf = new char[512];
                                    while (contentLength > 0 && (n = reader.read(buf, 0, thisTime = contentLength > buf.length ? buf.length : contentLength)) > 0) {
                                        result.append(buf, 0, n);
                                        contentLength -= n;
                                    }
                                }
                                if (pos != -1) {
                                    String string = result.toString();
                                    var24_32 = null;
                                    if (this.proxies[i].state == State.OK) return string;
                                    this.closeConnection(i);
                                    return string;
                                }
                                break block40;
                            }
                            if ("SYNTAX".equals(errorType)) {
                                this.proxies[i].state = State.DOWN;
                                log.error((Object)this.sm.getString("clusterListener.error.syntax", command, this.proxies[i], errorType, message));
                                break block40;
                            }
                            this.proxies[i].state = State.ERROR;
                            log.error((Object)this.sm.getString("clusterListener.error.other", command, this.proxies[i], errorType, message));
                        }
                        catch (IOException e) {
                            this.proxies[i].state = State.ERROR;
                            log.info((Object)this.sm.getString("clusterListener.error.io", command, this.proxies[i]), (Throwable)e);
                            var24_32 = null;
                            if (this.proxies[i].state != State.OK) {
                                this.closeConnection(i);
                            }
                        }
                    }
                    var24_32 = null;
                    if (this.proxies[i].state != State.OK) {
                        this.closeConnection(i);
                    }
                }
                catch (Throwable throwable) {
                    var24_32 = null;
                    if (this.proxies[i].state != State.OK) {
                        this.closeConnection(i);
                    }
                    throw throwable;
                }
            }
            ++i;
        }
        return null;
    }

    protected void sslInit() {
        if (this.ssl) {
            this.sslSocketFactory = new JSSESocketFactory(this);
        }
    }

    protected Socket getConnection(int i) throws IOException {
        if (this.connections[i] == null) {
            InetAddress address = this.proxies[i].address == null ? InetAddress.getLocalHost() : this.proxies[i].address;
            this.connections[i] = this.ssl ? this.sslSocketFactory.createSocket(address, this.proxies[i].port) : new Socket(address, this.proxies[i].port);
            this.connections[i].setSoTimeout(this.socketTimeout);
        }
        return this.connections[i];
    }

    protected BufferedReader getConnectionReader(int i) throws IOException {
        if (this.connectionReaders[i] == null) {
            this.connectionReaders[i] = new BufferedReader(new InputStreamReader(this.connections[i].getInputStream()));
        }
        return this.connectionReaders[i];
    }

    protected BufferedWriter getConnectionWriter(int i) throws IOException {
        if (this.connectionWriters[i] == null) {
            this.connectionWriters[i] = new BufferedWriter(new OutputStreamWriter(this.connections[i].getOutputStream()));
        }
        return this.connectionWriters[i];
    }

    protected void closeConnection(int i) {
        try {
            if (this.connectionReaders[i] != null) {
                this.connectionReaders[i].close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.connectionReaders[i] = null;
        try {
            if (this.connectionWriters[i] != null) {
                this.connectionWriters[i].close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.connectionWriters[i] = null;
        try {
            if (this.connections[i] != null) {
                this.connections[i].close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connections[i] = null;
    }

    protected static class Proxy {
        public InetAddress address = null;
        public int port = 8000;
        public State state = State.OK;

        protected Proxy() {
        }

        public String toString() {
            if (this.address == null) {
                return ":" + this.port;
            }
            return this.address.getHostAddress() + ":" + this.port;
        }

        public boolean equals(Object o) {
            if (o instanceof Proxy) {
                Proxy compare = (Proxy)o;
                if (this.port != compare.port) {
                    return false;
                }
                if (compare.address == null ? this.address == null : compare.address.equals(this.address) && this.port == compare.port) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        OK,
        ERROR,
        DOWN;

    }
}

