/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.common.beans.property.LocaleEditor;
import org.jboss.common.beans.property.PropertyEditorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateEditor
extends PropertyEditorSupport<Date> {
    private static DateFormat[] formats;
    private String text;

    public DateEditor() {
        super(Date.class);
    }

    public static void initialize() {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                SimpleDateFormat defaultDateFormat;
                String defaultFormat = System.getProperty("org.jboss.common.beans.property.DateEditor.format", "MMM d, yyyy");
                String defaultLocale = System.getProperty("org.jboss.common.beans.property.DateEditor.locale");
                if (defaultLocale == null || defaultLocale.length() == 0) {
                    defaultDateFormat = new SimpleDateFormat(defaultFormat);
                } else {
                    LocaleEditor localeEditor = new LocaleEditor();
                    localeEditor.setAsText(defaultLocale);
                    Locale locale = (Locale)localeEditor.getValue();
                    defaultDateFormat = new SimpleDateFormat(defaultFormat, locale);
                }
                DateEditor.access$002(new DateFormat[]{defaultDateFormat, new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z")});
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Date) && value != null) {
            throw new IllegalArgumentException("setValue() expected java.util.Date value, got " + value.getClass().getName());
        }
        this.text = null;
        super.setValue(value);
    }

    @Override
    public void setAsText(String text) {
        if (BeanUtils.isNull(text)) {
            this.setValue(null);
            return;
        }
        ParseException pe = null;
        for (int i = 0; i < formats.length; ++i) {
            try {
                DateFormat df = formats[i];
                Date date = df.parse(text);
                this.text = text;
                super.setValue(date);
                return;
            }
            catch (ParseException e) {
                pe = e;
                continue;
            }
        }
        throw new IllegalArgumentException("Failed to parse to Date!", pe);
    }

    @Override
    public String getAsText() {
        if (this.text == null) {
            DateFormat df = formats[formats.length - 1];
            Date date = (Date)this.getValue();
            this.text = df.format(date);
        }
        return this.text;
    }

    static /* synthetic */ DateFormat[] access$002(DateFormat[] x0) {
        formats = x0;
        return x0;
    }

    static {
        DateEditor.initialize();
    }
}

