/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.RemotingConnectionImpl;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;
import org.hornetq.core.protocol.core.impl.wireformat.DisconnectMessage;
import org.hornetq.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.hornetq.core.protocol.core.impl.wireformat.Ping;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.Connector;
import org.hornetq.spi.core.remoting.ConnectorFactory;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.OrderedExecutorFactory;
import org.hornetq.utils.VersionLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSessionFactoryImpl
implements ClientSessionFactoryInternal,
ConnectionLifeCycleListener {
    private static final long serialVersionUID = 2512460695662741413L;
    private static final Logger log = Logger.getLogger(ClientSessionFactoryImpl.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private static final boolean isDebug = log.isDebugEnabled();
    private final ServerLocatorInternal serverLocator;
    private TransportConfiguration connectorConfig;
    private TransportConfiguration backupConfig;
    private ConnectorFactory connectorFactory;
    private transient boolean finalizeCheck = true;
    private final long callTimeout;
    private final long clientFailureCheckPeriod;
    private final long connectionTTL;
    private final Set<ClientSessionInternal> sessions = new HashSet<ClientSessionInternal>();
    private final Object exitLock = new Object();
    private final Object createSessionLock = new Object();
    private boolean inCreateSession;
    private final Object failoverLock = new Object();
    private final ExecutorFactory orderedExecutorFactory;
    private final Executor threadPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private final Executor closeExecutor;
    private CoreRemotingConnection connection;
    private final long retryInterval;
    private final double retryIntervalMultiplier;
    private final long maxRetryInterval;
    private int reconnectAttempts;
    private final Set<SessionFailureListener> listeners = new ConcurrentHashSet<SessionFailureListener>();
    private Connector connector;
    private Future<?> pingerFuture;
    private PingRunnable pingRunnable;
    private volatile boolean exitLoop;
    private final List<Interceptor> interceptors;
    private volatile boolean stopPingingAfterOne;
    private volatile boolean closed;
    public final Exception e = new Exception();
    private final Object waitLock = new Object();

    public ClientSessionFactoryImpl(ServerLocatorInternal serverLocator, TransportConfiguration connectorConfig, long callTimeout, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, Executor threadPool, ScheduledExecutorService scheduledThreadPool, List<Interceptor> interceptors) {
        this.e.fillInStackTrace();
        this.serverLocator = serverLocator;
        this.connectorConfig = connectorConfig;
        this.connectorFactory = this.instantiateConnectorFactory(connectorConfig.getFactoryClassName());
        this.checkTransportKeys(this.connectorFactory, connectorConfig.getParams());
        this.callTimeout = callTimeout;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectionTTL = connectionTTL;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.reconnectAttempts = reconnectAttempts;
        this.scheduledThreadPool = scheduledThreadPool;
        this.threadPool = threadPool;
        this.orderedExecutorFactory = new OrderedExecutorFactory(threadPool);
        this.closeExecutor = this.orderedExecutorFactory.getExecutor();
        this.interceptors = interceptors;
    }

    @Override
    public void disableFinalizeCheck() {
        this.finalizeCheck = false;
    }

    @Override
    public void connect(int initialConnectAttempts, boolean failoverOnInitialConnection) throws HornetQException {
        this.getConnectionWithRetry(initialConnectAttempts);
        if (this.connection == null) {
            StringBuffer msg = new StringBuffer("Unable to connect to server using configuration ").append(this.connectorConfig);
            if (this.backupConfig != null) {
                msg.append(" and backup configuration ").append(this.backupConfig);
            }
            throw new HornetQException(2, msg.toString());
        }
    }

    @Override
    public TransportConfiguration getConnectorConfiguration() {
        return this.connectorConfig;
    }

    @Override
    public void setBackupConnector(TransportConfiguration live, TransportConfiguration backUp) {
        if (live.equals(this.connectorConfig) && backUp != null && !backUp.equals(this.connectorConfig)) {
            if (isDebug) {
                log.debug("Setting up backup config = " + backUp + " for live = " + live);
            }
            this.backupConfig = backUp;
        } else if (isDebug) {
            log.debug("ClientSessionFactoryImpl received backup update for live/backup pair = " + live + " / " + backUp + " but it didn't belong to " + this.connectorConfig);
        }
    }

    @Override
    public Object getBackupConnector() {
        return this.backupConfig;
    }

    @Override
    public ClientSession createSession(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize) throws HornetQException {
        return this.createSessionInternal(username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, ackBatchSize);
    }

    @Override
    public ClientSession createSession(boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws HornetQException {
        return this.createSessionInternal(null, null, false, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), ackBatchSize);
    }

    @Override
    public ClientSession createXASession() throws HornetQException {
        return this.createSessionInternal(null, null, true, false, false, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createTransactedSession() throws HornetQException {
        return this.createSessionInternal(null, null, false, false, false, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession() throws HornetQException {
        return this.createSessionInternal(null, null, false, true, true, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean autoCommitSends, boolean autoCommitAcks) throws HornetQException {
        return this.createSessionInternal(null, null, false, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws HornetQException {
        return this.createSessionInternal(null, null, xa, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge) throws HornetQException {
        return this.createSessionInternal(null, null, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.serverLocator.getAckBatchSize());
    }

    @Override
    public void connectionCreated(Acceptor acceptor, Connection connection, ProtocolType protocol) {
    }

    @Override
    public void connectionDestroyed(final Object connectionID) {
        final HornetQException ex = new HornetQException(2, "Channel disconnected");
        this.closeExecutor.execute(new Runnable(){

            public void run() {
                ClientSessionFactoryImpl.this.handleConnectionFailure(connectionID, ex);
            }
        });
    }

    @Override
    public void connectionException(Object connectionID, HornetQException me) {
        this.handleConnectionFailure(connectionID, me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(ClientSessionInternal session, boolean failingOver) {
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
    }

    @Override
    public void connectionReadyForWrites(Object connectionID, boolean ready) {
    }

    @Override
    public synchronized int numConnections() {
        return this.connection != null ? 1 : 0;
    }

    @Override
    public int numSessions() {
        return this.sessions.size();
    }

    @Override
    public void addFailureListener(SessionFailureListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeFailureListener(SessionFailureListener listener) {
        return this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void causeExit() {
        Object object = this.waitLock;
        synchronized (object) {
            this.exitLoop = true;
            this.waitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this.exitLock;
        synchronized (object) {
            this.exitLock.notifyAll();
        }
        this.forceReturnChannel1();
        this.causeExit();
        object = this.createSessionLock;
        synchronized (object) {
            Object object2 = this.failoverLock;
            synchronized (object2) {
                HashSet<ClientSessionInternal> sessionsToClose;
                Set<ClientSessionInternal> set = this.sessions;
                synchronized (set) {
                    sessionsToClose = new HashSet<ClientSessionInternal>(this.sessions);
                }
                for (ClientSession clientSession : sessionsToClose) {
                    try {
                        clientSession.close();
                    }
                    catch (HornetQException e) {
                        log.warn("Unable to close session", e);
                    }
                }
                this.checkCloseConnection();
            }
        }
        this.closed = true;
        this.serverLocator.factoryClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        if (this.closed) {
            return;
        }
        this.causeExit();
        Object object = this.createSessionLock;
        synchronized (object) {
            HashSet<ClientSessionInternal> sessionsToClose;
            Set<ClientSessionInternal> set = this.sessions;
            synchronized (set) {
                sessionsToClose = new HashSet<ClientSessionInternal>(this.sessions);
            }
            for (ClientSessionInternal session : sessionsToClose) {
                try {
                    session.cleanUp(false);
                }
                catch (Exception e) {
                    log.warn("Unable to close session", e);
                }
            }
            this.checkCloseConnection();
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.serverLocator.isClosed();
    }

    @Override
    public ServerLocator getServerLocator() {
        return this.serverLocator;
    }

    public void stopPingingAfterOne() {
        this.stopPingingAfterOne = true;
    }

    public void resumePinging() {
        this.stopPingingAfterOne = false;
    }

    private void handleConnectionFailure(Object connectionID, HornetQException me) {
        this.failoverOrReconnect(connectionID, me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failoverOrReconnect(Object connectionID, HornetQException me) {
        HashSet<ClientSessionInternal> sessionsToClose = null;
        Object object = this.failoverLock;
        synchronized (object) {
            if (this.connection == null || this.connection.getID() != connectionID) {
                return;
            }
            if (isTrace) {
                log.trace("Client Connection failed, calling failure listeners and trying to reconnect, reconnectAttempts=" + this.reconnectAttempts);
            }
            this.callFailureListeners(me, false, false);
            if (this.reconnectAttempts != 0) {
                boolean needToInterrupt;
                this.lockChannel1();
                Object object2 = this.exitLock;
                synchronized (object2) {
                    needToInterrupt = this.inCreateSession;
                }
                this.unlockChannel1();
                if (needToInterrupt) {
                    this.forceReturnChannel1();
                    object2 = this.exitLock;
                    synchronized (object2) {
                        while (this.inCreateSession) {
                            try {
                                this.exitLock.wait(5000L);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                }
                CoreRemotingConnection oldConnection = this.connection;
                this.connection = null;
                try {
                    this.connector.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                this.cancelScheduledTasks();
                this.connector = null;
                this.reconnectSessions(oldConnection, this.reconnectAttempts);
                if (oldConnection != null) {
                    oldConnection.destroy();
                }
            } else {
                CoreRemotingConnection connectionToDestory = this.connection;
                if (connectionToDestory != null) {
                    connectionToDestory.destroy();
                }
                this.connection = null;
            }
            if (this.connection == null) {
                Set<ClientSessionInternal> connectionToDestory = this.sessions;
                synchronized (connectionToDestory) {
                    sessionsToClose = new HashSet<ClientSessionInternal>(this.sessions);
                }
                this.callFailureListeners(me, true, false);
            }
        }
        if (this.connection != null) {
            this.callFailureListeners(me, true, true);
        }
        if (sessionsToClose != null) {
            for (ClientSessionInternal session : sessionsToClose) {
                try {
                    session.cleanUp(true);
                }
                catch (Exception e) {
                    log.error("Failed to cleanup session");
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private ClientSession createSessionInternal(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize) throws HornetQException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 21[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void callFailureListeners(HornetQException me, boolean afterReconnect, boolean failedOver) {
        ArrayList<SessionFailureListener> listenersClone = new ArrayList<SessionFailureListener>(this.listeners);
        for (SessionFailureListener listener : listenersClone) {
            try {
                if (afterReconnect) {
                    listener.connectionFailed(me, failedOver);
                    continue;
                }
                listener.beforeReconnect(me);
            }
            catch (Throwable t) {
                log.error("Failed to execute failure listener", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectSessions(CoreRemotingConnection oldConnection, int reconnectAttempts) {
        HashSet<ClientSessionInternal> sessionsToFailover;
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            sessionsToFailover = new HashSet<ClientSessionInternal>(this.sessions);
        }
        for (ClientSessionInternal session : sessionsToFailover) {
            session.preHandleFailover(this.connection);
        }
        this.getConnectionWithRetry(reconnectAttempts);
        if (this.connection == null) {
            log.warn("Failed to connect to server.");
            return;
        }
        List<FailureListener> oldListeners = oldConnection.getFailureListeners();
        ArrayList<FailureListener> newListeners = new ArrayList<FailureListener>(this.connection.getFailureListeners());
        for (FailureListener listener : oldListeners) {
            if (listener instanceof DelegatingFailureListener) continue;
            newListeners.add(listener);
        }
        this.connection.setFailureListeners(newListeners);
        for (ClientSessionInternal session : sessionsToFailover) {
            session.handleFailover(this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnectionWithRetry(int reconnectAttempts) {
        if (log.isTraceEnabled()) {
            log.trace("getConnectionWithRetry::" + reconnectAttempts + " with retryInterval = " + this.retryInterval + " multiplier = " + this.retryIntervalMultiplier, new Exception("trace"));
        }
        long interval = this.retryInterval;
        int count = 0;
        Object object = this.waitLock;
        synchronized (object) {
            while (!this.exitLoop) {
                if (isDebug) {
                    log.debug("Trying reconnection attempt " + count + "/" + reconnectAttempts);
                }
                this.getConnection();
                if (this.connection == null) {
                    if (reconnectAttempts != 0) {
                        if (reconnectAttempts != -1 && ++count == reconnectAttempts) {
                            if (reconnectAttempts != 1) {
                                log.warn("Tried " + reconnectAttempts + " times to connect. Now giving up on reconnecting it.");
                            } else if (reconnectAttempts == 1) {
                                log.debug("Trying to connect towards " + this);
                            }
                            return;
                        }
                        if (isTrace) {
                            log.trace("Waiting " + interval + " milliseconds before next retry. RetryInterval=" + this.retryInterval + " and multiplier = " + this.retryIntervalMultiplier);
                        }
                        try {
                            this.waitLock.wait(interval);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        long newInterval = (long)((double)interval * this.retryIntervalMultiplier);
                        if (newInterval > this.maxRetryInterval) {
                            newInterval = this.maxRetryInterval;
                        }
                        interval = newInterval;
                        continue;
                    }
                    log.debug("Could not connect to any server. Didn't have reconnection configured on the ClientSessionFactory");
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Reconnection successfull");
                }
                return;
            }
        }
    }

    private void cancelScheduledTasks() {
        if (this.pingerFuture != null) {
            this.pingRunnable.cancel();
            this.pingerFuture.cancel(false);
            this.pingRunnable = null;
            this.pingerFuture = null;
        }
    }

    private void checkCloseConnection() {
        if (this.connection != null && this.sessions.size() == 0) {
            this.cancelScheduledTasks();
            try {
                this.connection.destroy();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.connection = null;
            try {
                if (this.connector != null) {
                    this.connector.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connector = null;
        }
    }

    @Override
    public CoreRemotingConnection getConnection() {
        if (this.connection == null) {
            Connection tc;
            block33: {
                tc = null;
                try {
                    DelegatingBufferHandler handler = new DelegatingBufferHandler();
                    this.connector = this.connectorFactory.createConnector(this.connectorConfig.getParams(), handler, this, this.closeExecutor, this.threadPool, this.scheduledThreadPool);
                    if (log.isDebugEnabled()) {
                        log.debug("Trying to connect with connector = " + this.connectorFactory + ", parameters = " + this.connectorConfig.getParams() + " connector = " + this.connector);
                    }
                    if (this.connector != null) {
                        this.connector.start();
                        if (isDebug) {
                            log.debug("Trying to connect at the main server using connector :" + this.connectorConfig);
                        }
                        if ((tc = this.connector.createConnection()) == null) {
                            if (isDebug) {
                                log.debug("Main server is not up. Hopefully there's a backup configured now!");
                            }
                            try {
                                this.connector.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            this.connector = null;
                        }
                    }
                    if (this.connector != null) break block33;
                    if (this.backupConfig != null) {
                        if (isDebug) {
                            log.debug("Trying backup config = " + this.backupConfig);
                        }
                        ConnectorFactory backupConnectorFactory = this.instantiateConnectorFactory(this.backupConfig.getFactoryClassName());
                        this.connector = backupConnectorFactory.createConnector(this.backupConfig.getParams(), handler, this, this.closeExecutor, this.threadPool, this.scheduledThreadPool);
                        if (this.connector == null) break block33;
                        this.connector.start();
                        tc = this.connector.createConnection();
                        if (tc == null) {
                            if (isDebug) {
                                log.debug("Backup is not active yet");
                            }
                            try {
                                this.connector.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            this.connector = null;
                            break block33;
                        }
                        if (isDebug) {
                            log.debug("Connected to the backup at " + this.backupConfig);
                        }
                        this.connectorConfig = this.backupConfig;
                        this.backupConfig = null;
                        this.connectorFactory = backupConnectorFactory;
                        break block33;
                    }
                    if (isTrace) {
                        log.trace("No Backup configured!", new Exception("trace"));
                    }
                }
                catch (Exception e) {
                    log.warn("connector.create or connectorFactory.createConnector should never throw an exception, implementation is badly behaved, but we'll deal with it anyway.", e);
                    if (tc != null) {
                        try {
                            tc.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (this.connector != null) {
                        try {
                            this.connector.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    tc = null;
                    this.connector = null;
                }
            }
            if (tc == null) {
                if (isTrace) {
                    log.trace("returning connection = " + this.connection + " as tc == null");
                }
                return this.connection;
            }
            this.connection = new RemotingConnectionImpl(tc, this.callTimeout, this.interceptors);
            this.connection.addFailureListener(new DelegatingFailureListener(this.connection.getID()));
            Channel channel0 = this.connection.getChannel(0L, -1);
            channel0.setHandler(new Channel0Handler(this.connection));
            if (this.clientFailureCheckPeriod != -1L) {
                if (this.pingerFuture == null) {
                    this.pingRunnable = new PingRunnable();
                    this.pingerFuture = this.scheduledThreadPool.scheduleWithFixedDelay(new ActualScheduledPinger(this.pingRunnable), 0L, this.clientFailureCheckPeriod, TimeUnit.MILLISECONDS);
                    this.pingRunnable.send();
                } else {
                    this.pingRunnable.run();
                }
            }
            if (this.serverLocator.getTopology() != null) {
                if (isTrace) {
                    log.trace(this + "::Subscribing Topology");
                }
                channel0.send(new SubscribeClusterTopologyUpdatesMessageV2(this.serverLocator.isClusterConnection(), VersionLoader.getVersion().getIncrementingVersion()));
            }
        }
        if (this.serverLocator.getAfterConnectInternalListener() != null) {
            this.serverLocator.getAfterConnectInternalListener().onConnection(this);
        }
        if (log.isTraceEnabled()) {
            log.trace("returning " + this.connection);
        }
        return this.connection;
    }

    @Override
    public void sendNodeAnnounce(long currentEventID, String nodeID, boolean isBackup, TransportConfiguration config, TransportConfiguration backupConfig) {
        Channel channel0 = this.connection.getChannel(0L, -1);
        if (isDebug) {
            log.debug("Announcing node " + this.serverLocator.getNodeID() + ", isBackup=" + isBackup);
        }
        channel0.send(new NodeAnnounceMessage(currentEventID, nodeID, isBackup, config, backupConfig));
    }

    public void finalize() throws Throwable {
        if (!this.closed && this.finalizeCheck) {
            log.warn("I'm closing a core ClientSessionFactory you left open. Please make sure you close all ClientSessionFactories explicitly before letting them go out of scope! " + System.identityHashCode(this));
            log.warn("The ClientSessionFactory you didn't close was created here:", this.e);
            this.close();
        }
        super.finalize();
    }

    private ConnectorFactory instantiateConnectorFactory(final String connectorFactoryClassName) {
        return AccessController.doPrivileged(new PrivilegedAction<ConnectorFactory>(){

            @Override
            public ConnectorFactory run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(connectorFactoryClassName);
                    return (ConnectorFactory)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error instantiating connector factory \"" + connectorFactoryClassName + "\"", e);
                }
            }
        });
    }

    private void lockChannel1() {
        Channel channel1;
        if (this.connection != null && (channel1 = this.connection.getChannel(1L, -1)) != null) {
            channel1.getLock().lock();
        }
    }

    private void unlockChannel1() {
        Channel channel1;
        if (this.connection != null && (channel1 = this.connection.getChannel(1L, -1)) != null) {
            channel1.getLock().unlock();
        }
    }

    private void forceReturnChannel1() {
        Channel channel1;
        if (this.connection != null && (channel1 = this.connection.getChannel(1L, -1)) != null) {
            channel1.returnBlocking();
        }
    }

    private void checkTransportKeys(ConnectorFactory factory, Map<String, Object> params) {
        Set<String> invalid;
        if (params != null && !(invalid = ConfigurationHelper.checkKeys(factory.getAllowableProperties(), params.keySet())).isEmpty()) {
            String msg = ConfigurationHelper.stringSetToCommaListString("The following keys are invalid for configuring a connector: ", invalid);
            throw new IllegalStateException(msg);
        }
    }

    public String toString() {
        return "ClientSessionFactoryImpl [serverLocator=" + this.serverLocator + ", connectorConfig=" + this.connectorConfig + ", backupConfig=" + this.backupConfig + "]";
    }

    @Override
    public void setReconnectAttempts(int attempts) {
        this.reconnectAttempts = attempts;
    }

    @Override
    public Object getConnector() {
        return this.connector;
    }

    private final class PingRunnable
    implements Runnable {
        private boolean cancelled;
        private boolean first;
        private long lastCheck = System.currentTimeMillis();

        private PingRunnable() {
        }

        public synchronized void run() {
            if (this.cancelled || ClientSessionFactoryImpl.this.stopPingingAfterOne && !this.first) {
                return;
            }
            this.first = false;
            long now = System.currentTimeMillis();
            if (ClientSessionFactoryImpl.this.clientFailureCheckPeriod != -1L && ClientSessionFactoryImpl.this.connectionTTL != -1L && now >= this.lastCheck + ClientSessionFactoryImpl.this.connectionTTL) {
                if (!ClientSessionFactoryImpl.this.connection.checkDataReceived()) {
                    final HornetQException me = new HornetQException(3, "Did not receive data from server for " + ClientSessionFactoryImpl.this.connection.getTransportConnection());
                    this.cancelled = true;
                    ClientSessionFactoryImpl.this.threadPool.execute(new Runnable(){

                        public void run() {
                            ClientSessionFactoryImpl.this.connection.fail(me);
                        }
                    });
                    return;
                }
                this.lastCheck = now;
            }
            this.send();
        }

        public void send() {
            Ping ping = new Ping(ClientSessionFactoryImpl.this.connectionTTL);
            Channel channel0 = ClientSessionFactoryImpl.this.connection.getChannel(0L, -1);
            channel0.send(ping);
            ClientSessionFactoryImpl.this.connection.flush();
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private static final class ActualScheduledPinger
    implements Runnable {
        private final WeakReference<PingRunnable> pingRunnable;

        ActualScheduledPinger(PingRunnable runnable) {
            this.pingRunnable = new WeakReference<PingRunnable>(runnable);
        }

        public void run() {
            PingRunnable runnable = (PingRunnable)this.pingRunnable.get();
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    private class DelegatingFailureListener
    implements FailureListener {
        private final Object connectionID;

        DelegatingFailureListener(Object connectionID) {
            this.connectionID = connectionID;
        }

        public void connectionFailed(HornetQException me, boolean failedOver) {
            ClientSessionFactoryImpl.this.handleConnectionFailure(this.connectionID, me);
        }
    }

    private class DelegatingBufferHandler
    implements BufferHandler {
        private DelegatingBufferHandler() {
        }

        public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
            CoreRemotingConnection theConn = ClientSessionFactoryImpl.this.connection;
            if (theConn != null && connectionID == theConn.getID()) {
                theConn.bufferReceived(connectionID, buffer);
            }
        }
    }

    private class Channel0Handler
    implements ChannelHandler {
        private final CoreRemotingConnection conn;

        private Channel0Handler(CoreRemotingConnection conn) {
            this.conn = conn;
        }

        public void handlePacket(Packet packet) {
            byte type = packet.getType();
            if (type == 11) {
                DisconnectMessage msg = (DisconnectMessage)packet;
                SimpleString nodeID = msg.getNodeID();
                if (log.isTraceEnabled()) {
                    log.trace("Disconnect being called on client:" + msg + " server locator = " + ClientSessionFactoryImpl.this.serverLocator + " notifying node " + nodeID + " as down", new Exception("trace"));
                }
                if (nodeID != null) {
                    ClientSessionFactoryImpl.this.serverLocator.notifyNodeDown(System.currentTimeMillis(), msg.getNodeID().toString());
                }
                ClientSessionFactoryImpl.this.closeExecutor.execute(new Runnable(){

                    public void run() {
                        Channel0Handler.this.conn.fail(new HornetQException(4, "The connection was disconnected because of server shutdown"));
                    }
                });
            } else if (type == 110) {
                ClusterTopologyChangeMessage topMessage = (ClusterTopologyChangeMessage)packet;
                this.notifyTopologyChange(topMessage);
            } else if (type == 114) {
                ClusterTopologyChangeMessage_V2 topMessage = (ClusterTopologyChangeMessage_V2)packet;
                this.notifyTopologyChange(topMessage);
            }
        }

        private void notifyTopologyChange(final ClusterTopologyChangeMessage topMessage) {
            ClientSessionFactoryImpl.this.threadPool.execute(new Runnable(){

                public void run() {
                    Pair<TransportConfiguration, TransportConfiguration> transportConfig;
                    long eventUID = topMessage instanceof ClusterTopologyChangeMessage_V2 ? ((ClusterTopologyChangeMessage_V2)topMessage).getUniqueEventID() : System.currentTimeMillis();
                    if (topMessage.isExit()) {
                        if (isDebug) {
                            log.debug("Notifying " + topMessage.getNodeID() + " going down");
                        }
                        ClientSessionFactoryImpl.this.serverLocator.notifyNodeDown(eventUID, topMessage.getNodeID());
                        return;
                    }
                    if (isDebug) {
                        log.debug("Node " + topMessage.getNodeID() + " going up, connector = " + topMessage.getPair() + ", isLast=" + topMessage.isLast() + " csf created at\nserverLocator=" + ClientSessionFactoryImpl.this.serverLocator, ClientSessionFactoryImpl.this.e);
                    }
                    if ((transportConfig = topMessage.getPair()).getA() == null && transportConfig.getB() == null) {
                        transportConfig = new Pair<TransportConfiguration, Object>(Channel0Handler.this.conn.getTransportConnection().getConnectorConfig(), null);
                    }
                    ClientSessionFactoryImpl.this.serverLocator.notifyNodeUp(eventUID, topMessage.getNodeID(), transportConfig, topMessage.isLast());
                }
            });
        }
    }
}

