/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.servletunit.InvocationContextFactory;
import com.meterware.servletunit.ServletTestCase;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;

public class JUnitServlet
extends HttpServlet {
    private InvocationContextFactory _factory;

    public JUnitServlet() {
    }

    protected JUnitServlet(InvocationContextFactory factory) {
        this._factory = factory;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResultsFormatter formatter = this.getResultsFormatter(request.getParameter("format"));
        response.setContentType(formatter.getContentType());
        String testName = request.getParameter("test");
        if (testName == null || testName.length() == 0) {
            this.reportCannotRunTest(response.getWriter(), "No test class specified");
        } else {
            ServletTestRunner runner = new ServletTestRunner(response.getWriter(), formatter);
            runner.runTestSuite(testName);
        }
        response.getWriter().close();
    }

    private ResultsFormatter getResultsFormatter(String formatterName) {
        if ("text".equalsIgnoreCase(formatterName)) {
            return new TextResultsFormatter();
        }
        if ("xml".equalsIgnoreCase(formatterName)) {
            return new XMLResultsFormatter();
        }
        return new HTMLResultsFormatter();
    }

    private void reportCannotRunTest(PrintWriter writer, String errorMessage) {
        writer.print("<html><head><title>Cannot run test</title></head><body>" + errorMessage + "</body></html>");
    }

    static class XMLResultsFormatter
    extends ResultsFormatter {
        XMLResultsFormatter() {
        }

        @Override
        String getContentType() {
            return "text/xml;charset=UTF-8";
        }

        @Override
        protected void displayHeader(PrintWriter writer, String testClassName, TestResult testResult, String elapsedTimeString) {
            writer.println("<?xml version='1.0' encoding='UTF-8' ?>\n<testsuite name=" + this.asAttribute(testClassName) + " tests=" + this.asAttribute(testResult.runCount()) + " failures=" + this.asAttribute(testResult.failureCount()) + " errors=" + this.asAttribute(testResult.errorCount()) + " time=" + this.asAttribute(elapsedTimeString) + ">");
        }

        private String asAttribute(int value) {
            return '\"' + Integer.toString(value) + '\"';
        }

        private String asAttribute(String value) {
            return '\"' + this.sgmlEscape(value) + '\"';
        }

        @Override
        protected void displayFooter(PrintWriter writer) {
            writer.println("</testsuite>");
        }

        @Override
        protected void displayResults(PrintWriter writer, TestResult testResult) {
            this.displayResults(writer, "failure", testResult.failures());
            this.displayResults(writer, "error", testResult.errors());
        }

        private void displayResults(PrintWriter writer, String failureNodeName, Enumeration resultsEnumeration) {
            Enumeration e = resultsEnumeration;
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                writer.println("  <testcase name=" + this.asAttribute(failure.failedTest().toString()) + ">");
                writer.print("    <" + failureNodeName + " type=" + this.asAttribute(failure.thrownException().getClass().getName()) + " message=" + this.asAttribute(failure.exceptionMessage()));
                if (!this.displayException(failure)) {
                    writer.println("/>");
                } else {
                    writer.println(">");
                    writer.print(this.sgmlEscape(BaseTestRunner.getFilteredTrace((Throwable)failure.thrownException())));
                    writer.println("    </" + failureNodeName + ">");
                }
                writer.println("  </testcase>");
            }
        }

        private boolean displayException(TestFailure failure) {
            return true;
        }

        @Override
        protected String getLineBreak() {
            return "";
        }
    }

    static class HTMLResultsFormatter
    extends DisplayedResultsFormatter {
        HTMLResultsFormatter() {
        }

        @Override
        String getContentType() {
            return "text/html";
        }

        @Override
        protected void displayHeader(PrintWriter writer, String testClassName, String testCountText, String elapsedTimeString, String resultString) {
            writer.println("<html><head><title>Test Suite: " + testClassName + "</title>");
            writer.println("<style type='text/css'>");
            writer.println("<!--");
            writer.println("  td.detail { font-size:smaller; vertical-align: top }");
            writer.println("  -->");
            writer.println("</style></head><body>");
            writer.println("<table id='results' border='1'><tr>");
            writer.println("<td>" + testCountText + "</td>");
            writer.println("<td>Time: " + elapsedTimeString + "</td>");
            writer.println("<td>" + resultString + "</td></tr>");
        }

        @Override
        protected void displayFooter(PrintWriter writer) {
            writer.println("</table>");
            writer.println("</body></html>");
        }

        @Override
        protected void displayProblemTitle(PrintWriter writer, String title) {
            writer.println("<tr><td colspan=3>" + title + "</td></tr>");
        }

        @Override
        protected void displayProblemDetailHeader(PrintWriter writer, int i, String testName) {
            writer.println("<tr><td class='detail' align='right'>" + i + "</td>");
            writer.println("<td class='detail'>" + testName + "</td><td class='detail'>");
        }

        @Override
        protected void displayProblemDetailFooter(PrintWriter writer) {
            writer.println("</td></tr>");
        }

        @Override
        protected void displayProblemDetail(PrintWriter writer, String message) {
            writer.println(this.sgmlEscape(message));
        }
    }

    static class TextResultsFormatter
    extends DisplayedResultsFormatter {
        TextResultsFormatter() {
        }

        @Override
        String getContentType() {
            return "text/plain";
        }

        @Override
        protected void displayHeader(PrintWriter writer, String testClassName, String testCountText, String elapsedTimeString, String resultString) {
            writer.println(testClassName + " (" + testCountText + "): " + resultString);
        }

        @Override
        protected void displayFooter(PrintWriter writer) {
        }

        @Override
        protected void displayProblemTitle(PrintWriter writer, String title) {
            writer.println();
            writer.println(title + ':');
        }

        @Override
        protected void displayProblemDetailHeader(PrintWriter writer, int i, String testName) {
            writer.println(i + ". " + testName + ":");
        }

        @Override
        protected void displayProblemDetailFooter(PrintWriter writer) {
            writer.println();
        }

        @Override
        protected void displayProblemDetail(PrintWriter writer, String message) {
            writer.println(message);
        }
    }

    static abstract class DisplayedResultsFormatter
    extends ResultsFormatter {
        DisplayedResultsFormatter() {
        }

        @Override
        protected void displayHeader(PrintWriter writer, String testClassName, TestResult testResult, String elapsedTimeString) {
            this.displayHeader(writer, testClassName, this.getFormatted(testResult.runCount(), "test"), elapsedTimeString, testResult.wasSuccessful() ? "OK" : "Problems Occurred");
        }

        @Override
        protected void displayResults(PrintWriter writer, TestResult testResult) {
            if (!testResult.wasSuccessful()) {
                this.displayProblems(writer, "failure", testResult.failureCount(), testResult.failures());
                this.displayProblems(writer, "error", testResult.errorCount(), testResult.errors());
            }
        }

        protected abstract void displayHeader(PrintWriter var1, String var2, String var3, String var4, String var5);

        protected abstract void displayProblemTitle(PrintWriter var1, String var2);

        protected abstract void displayProblemDetailHeader(PrintWriter var1, int var2, String var3);

        protected abstract void displayProblemDetailFooter(PrintWriter var1);

        protected abstract void displayProblemDetail(PrintWriter var1, String var2);

        private void displayProblems(PrintWriter writer, String kind, int count, Enumeration enumeration) {
            if (count != 0) {
                this.displayProblemTitle(writer, this.getFormatted(count, kind));
                Enumeration e = enumeration;
                int i = 1;
                while (e.hasMoreElements()) {
                    TestFailure failure = (TestFailure)e.nextElement();
                    this.displayProblemDetailHeader(writer, i, failure.failedTest().toString());
                    if (failure.thrownException() instanceof AssertionFailedError) {
                        this.displayProblemDetail(writer, failure.thrownException().getMessage());
                    } else {
                        this.displayProblemDetail(writer, BaseTestRunner.getFilteredTrace((Throwable)failure.thrownException()));
                    }
                    this.displayProblemDetailFooter(writer);
                    ++i;
                }
            }
        }

        private String getFormatted(int count, String name) {
            return count + " " + name + (count == 1 ? "" : "s");
        }
    }

    static abstract class ResultsFormatter {
        private static final char LF = '\n';
        private static final char CR = '\r';

        ResultsFormatter() {
        }

        abstract String getContentType();

        void displayResults(PrintWriter writer, String testClassName, String elapsedTimeString, TestResult testResult) {
            this.displayHeader(writer, testClassName, testResult, elapsedTimeString);
            this.displayResults(writer, testResult);
            this.displayFooter(writer);
        }

        protected abstract void displayHeader(PrintWriter var1, String var2, TestResult var3, String var4);

        protected abstract void displayResults(PrintWriter var1, TestResult var2);

        protected abstract void displayFooter(PrintWriter var1);

        protected String sgmlEscape(String s) {
            if (s == null) {
                return "NULL";
            }
            StringBuffer result = new StringBuffer(s.length());
            char[] chars = s.toCharArray();
            block7: for (int i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '&': {
                        result.append("&amp;");
                        continue block7;
                    }
                    case '<': {
                        result.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        result.append("&gt;");
                        continue block7;
                    }
                    case '\n': {
                        if (i > 0 && chars[i - 1] == '\r') {
                            result.append(chars[i]);
                            continue block7;
                        }
                    }
                    case '\r': {
                        result.append(this.getLineBreak());
                    }
                    default: {
                        result.append(chars[i]);
                    }
                }
            }
            return result.toString();
        }

        protected String getLineBreak() {
            return "<br>";
        }
    }

    class ServletTestRunner
    extends BaseTestRunner {
        private PrintWriter _writer;
        private ResultsFormatter _formatter;

        public ServletTestRunner(PrintWriter writer, ResultsFormatter formatter) {
            ServletTestCase.setInvocationContextFactory(JUnitServlet.this._factory);
            this._writer = writer;
            this._formatter = formatter;
        }

        void runTestSuite(String testClassName) {
            Test suite = this.getTest(testClassName);
            if (suite != null) {
                TestResult testResult = new TestResult();
                testResult.addListener((TestListener)this);
                long startTime = System.currentTimeMillis();
                suite.run(testResult);
                long endTime = System.currentTimeMillis();
                this._formatter.displayResults(this._writer, testClassName, this.elapsedTimeAsString(endTime - startTime), testResult);
            }
        }

        public void addError(Test test, Throwable throwable) {
        }

        public void addFailure(Test test, AssertionFailedError error) {
        }

        public void endTest(Test test) {
        }

        protected void runFailed(String s) {
            JUnitServlet.this.reportCannotRunTest(this._writer, s);
        }

        public void startTest(Test test) {
        }

        public void testStarted(String s) {
        }

        public void testEnded(String s) {
        }

        public void testFailed(int i, Test test, Throwable throwable) {
        }

        public TestSuiteLoader getLoader() {
            return new StandardTestSuiteLoader();
        }
    }
}

