/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;

public class McastSenderTest {
    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        sock = null;
        sockets = null;
        mcast_addr = null;
        bind_addr = null;
        buf = new byte[]{};
        ttl = 32;
        ack_receiver = null;
        port = 5555;
        send_on_all_interfaces = false;
        try {
            for (i = 0; i < args.length; ++i) {
                tmp = args[i];
                if ("-help".equals(tmp)) {
                    McastSenderTest.help();
                    return;
                }
                if ("-bind_addr".equals(tmp)) {
                    bind_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-mcast_addr".equals(tmp)) {
                    mcast_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-ttl".equals(tmp)) {
                    ttl = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-port".equals(tmp)) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-send_on_all_interfaces".equals(args[i])) {
                    send_on_all_interfaces = true;
                    continue;
                }
                McastSenderTest.help();
                return;
            }
            if (mcast_addr == null) {
                mcast_addr = InetAddress.getByName("224.0.0.150");
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
        try {
            if (send_on_all_interfaces) {
                sockets = new ArrayList<MulticastSocket>(10);
                en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    intf = en.nextElement();
                    s = new MulticastSocket();
                    sockets.add(s);
                    s.setTimeToLive(ttl);
                    s.setNetworkInterface(intf);
                    System.out.println("Socket=" + s.getLocalAddress() + ':' + s.getLocalPort() + ", ttl=" + s.getTimeToLive() + ", bind interface=" + s.getInterface());
                    ack_receiver = new AckReceiver(s);
                    ack_receiver.start();
                }
            } else {
                sock = new MulticastSocket();
                sock.setTimeToLive(ttl);
                if (bind_addr != null) {
                    sock.setInterface(bind_addr);
                }
                System.out.println("Socket=" + sock.getLocalAddress() + ':' + sock.getLocalPort() + ", ttl=" + sock.getTimeToLive() + ", bind interface=" + sock.getInterface());
                ack_receiver = new AckReceiver(sock);
                ack_receiver.start();
            }
            in = new DataInputStream(System.in);
            block10: while (true) {
                System.out.print("> ");
                line = in.readLine();
                if (line.startsWith("quit") || line.startsWith("exit")) {
                    if (ack_receiver != null) {
                        ack_receiver.stop();
                    }
                    break;
                }
                buf = line.getBytes();
                packet = new DatagramPacket(buf, buf.length, mcast_addr, port);
                if (sock != null) {
                    try {
                        sock.send(packet);
                    }
                    catch (Throwable t) {
                        System.err.println(t);
                    }
                    continue;
                }
                i = 0;
                while (true) {
                    if (i < sockets.size()) ** break;
                    continue block10;
                    s = (MulticastSocket)sockets.get(i);
                    try {
                        s.send(packet);
                    }
                    catch (Throwable t) {
                        System.err.println(t);
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("McastSenderTest [-bind_addr <bind address>] [-help] [-mcast_addr <multicast address>] [-port <multicast port that receivers are listening on>] [-ttl <time to live for mcast packets>] [-send_on_all_interfaces]");
    }

    private static class AckReceiver
    implements Runnable {
        DatagramSocket sock;
        DatagramPacket packet;
        byte[] buf;
        Thread t = null;

        AckReceiver(DatagramSocket sock) {
            this.sock = sock;
        }

        @Override
        public void run() {
            while (this.t != null) {
                try {
                    this.buf = new byte[256];
                    this.packet = new DatagramPacket(this.buf, this.buf.length);
                    this.sock.receive(this.packet);
                    System.out.println("<< Received response from " + this.packet.getAddress().getHostAddress() + ':' + this.packet.getPort() + ": " + new String(this.packet.getData(), 0, this.packet.getLength()));
                }
                catch (Exception e) {
                    System.err.println(e);
                    break;
                }
            }
            this.t = null;
        }

        void start() {
            this.t = new Thread((Runnable)this, "McastSenderTest.AckReceiver thread");
            this.t.start();
        }

        void stop() {
            if (this.t != null && this.t.isAlive()) {
                this.t = null;
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

