/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.PrimitiveType;

public class FloatType
extends PrimitiveType {
    @Override
    public Serializable getDefaultValue() {
        return new Float(0.0);
    }

    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        return new Float(rs.getFloat(name));
    }

    @Override
    public Class getPrimitiveClass() {
        return Float.TYPE;
    }

    @Override
    public Class getReturnedClass() {
        return Float.class;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setFloat(index, ((Float)value).floatValue());
    }

    @Override
    public int sqlType() {
        return 6;
    }

    @Override
    public String getName() {
        return "float";
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return value.toString();
    }

    @Override
    public Object fromStringValue(String xml) {
        return new Float(xml);
    }
}

