/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.jpa.jbpapp9336;

import javax.ejb.Stateless;
import javax.ejb.Remote;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.PersistenceContext;
import javax.transaction.TransactionManager;

import org.hibernate.Session;
import org.jboss.ejb3.annotation.JndiInject;

/**
 * @author Navin Surtani (navssurtani)
 * 
 * StateLess Session Bean (SLSB) implementation of {@link HandlerTest} that will provide the actual required functionality for the testing purposes of JBPAPP-9336.
 */

@Stateless
@Remote(HandlerTest.class)

public class HandlerTestBean implements HandlerTest {

    private @PersistenceContext EntityManager em;
    private @JndiInject(jndiName="java:/TransactionManager") TransactionManager tm;
    
    public EntityWithHandlerAttribute createEntityWithHandlerAttribute(String handler) {
        
        // Create a new instance of EWHA using the constructor and persist it using the EntityManager.
        
        EntityWithHandlerAttribute ewha = new EntityWithHandlerAttribute();
        ewha.setHandler(handler);
        em.persist(ewha);
        return ewha;
    }

    public EntityWithHandlerAttribute loadEntityWithHandlerAttribute(Long id) {
       
        // Simply use the EntityManager to make a find call using the id passed as a parameter. We already know the 
        // class type that we are looking for which is an EWHA.
        
        return em.find(EntityWithHandlerAttribute.class, id);
    }
    
    
}
