/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jnp.server;

import java.rmi.RemoteException;
import java.util.Collection;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;

import org.jnp.interfaces.Naming;

/**
 * NamingServerGuard will be registered instead of NamingServer to receive all RMIs and decide what 
 * will come through to NamingServer.
 *  
 * @author Peter Skopek <pskopek@redhat.com>
 *
 */
public class NamingServerGuard
   implements Naming, java.io.Serializable
{
   
   private static final long serialVersionUID = 1875763972368932742L;
   
   private final Naming securedNaming;
   
   public static final String GUARDED_JNDI_METHOD_NAMES = "bind,rebind,unbind,createSubcontext";


   
   public NamingServerGuard(Naming securedNaming) {

      this.securedNaming = securedNaming;
   }
   
   public void bind(Name name, Object obj, String className)
         throws NamingException, RemoteException {
      
      throw new NoPermissionException("bind JNDI operation not allowed when calling from outside NamingServer's VM.");
   }

   public void rebind(Name name, Object obj, String className)
         throws NamingException, RemoteException {

      throw new NoPermissionException("rebind JNDI operation not allowed when calling from outside NamingServer's VM.");
   }

   public void unbind(Name name) throws NamingException, RemoteException {

      throw new NoPermissionException("unbind JNDI operation not allowed when calling from outside NamingServer's VM.");
   }

   public Object lookup(Name name) throws NamingException, RemoteException {
      return securedNaming.lookup(name);
   }

   public Collection list(Name name) throws NamingException, RemoteException {
      return securedNaming.list(name);
   }

   public Collection listBindings(Name name) throws NamingException,
         RemoteException {
      
      return securedNaming.listBindings(name);
   }

   public Context createSubcontext(Name name) throws NamingException,
         RemoteException {
   
      throw new NoPermissionException("createSubcontext JNDI operation not allowed when calling from outside NamingServer's VM.");
   }

}
