/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.security;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.transport.http.auth.AbstractSpnegoAuthSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosAuthOutInterceptor
extends AbstractSpnegoAuthSupplier
implements PhaseInterceptor<Message> {
    private String phase = "marshal";
    private AuthorizationPolicy policy;

    public KerberosAuthOutInterceptor() {
    }

    public KerberosAuthOutInterceptor(String phase) {
        this.phase = phase;
    }

    public void handleMessage(Message message) throws Fault {
        URL currentURL = this.getCurrentURL(message);
        String value = super.getAuthorization(this.getPolicy(), currentURL, message);
        HashMap<String, List<String>> headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (headers == null) {
            headers = new HashMap<String, List<String>>();
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        headers.put("Authorization", Collections.singletonList(value));
    }

    private URL getCurrentURL(Message message) {
        try {
            return new URL((String)message.get((Object)Message.ENDPOINT_ADDRESS));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void handleFault(Message message) {
    }

    public Set<String> getAfter() {
        return Collections.emptySet();
    }

    public Set<String> getBefore() {
        return Collections.emptySet();
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPhase() {
        return this.phase;
    }

    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return Collections.emptySet();
    }

    public AuthorizationPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(AuthorizationPolicy policy) {
        this.policy = policy;
    }
}

