/*
 * Decompiled with CFR 0.152.
 */
package org.core4j;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import org.core4j.Enumerable;
import org.core4j.Func;
import org.core4j.ReadOnlyIterator;
import org.core4j.ThrowingFunc;

public class Enumerables {
    public static Enumerable<String> lines(final InputStream stream) {
        final ThrowingFunc<Reader> source = new ThrowingFunc<Reader>(){

            @Override
            public Reader apply() throws Exception {
                return new InputStreamReader(stream);
            }
        };
        return Enumerable.createFromIterator(new Func<Iterator<String>>(){

            @Override
            public Iterator<String> apply() {
                return new ReaderLinesIterator(source);
            }
        });
    }

    public static Enumerable<Character> chars(String value) {
        return Enumerables.chars(value.toCharArray());
    }

    public static Enumerable<Character> chars(char[] chars) {
        Character[] rt = new Character[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            rt[i] = Character.valueOf(chars[i]);
        }
        return Enumerable.create(rt);
    }

    public static Enumerable<String> lines(final URL url) {
        final ThrowingFunc<Reader> source = new ThrowingFunc<Reader>(){

            @Override
            public Reader apply() throws Exception {
                return new InputStreamReader(url.openStream());
            }
        };
        return Enumerable.createFromIterator(new Func<Iterator<String>>(){

            @Override
            public Iterator<String> apply() {
                return new ReaderLinesIterator(source);
            }
        });
    }

    public static Enumerable<String> lines(final File file) {
        final ThrowingFunc<Reader> source = new ThrowingFunc<Reader>(){

            @Override
            public Reader apply() throws Exception {
                return new FileReader(file);
            }
        };
        return Enumerable.createFromIterator(new Func<Iterator<String>>(){

            @Override
            public Iterator<String> apply() {
                return new ReaderLinesIterator(source);
            }
        });
    }

    private static class ReaderLinesIterator
    extends ReadOnlyIterator<String> {
        private final ThrowingFunc<Reader> readerSource;
        private BufferedReader reader;

        public ReaderLinesIterator(ThrowingFunc<Reader> readerSource) {
            this.readerSource = readerSource;
        }

        @Override
        protected ReadOnlyIterator.IterationResult<String> advance() throws Exception {
            String line;
            if (this.reader == null) {
                this.reader = new BufferedReader(this.readerSource.apply());
            }
            if ((line = this.reader.readLine()) == null) {
                this.reader.close();
                return ReadOnlyIterator.IterationResult.done();
            }
            return ReadOnlyIterator.IterationResult.next(line);
        }
    }
}

