/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer.behaviors;

import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.consumer.behaviors.AzureTableBehavior;
import org.odata4j.consumer.behaviors.BasicAuthenticationBehavior;
import org.odata4j.consumer.behaviors.MethodTunnelingBehavior;
import org.odata4j.consumer.behaviors.OClientBehavior;
import org.odata4j.core.Throwables;

public class OClientBehaviors {
    private OClientBehaviors() {
    }

    public static OClientBehavior basicAuth(String user, String password) {
        return new BasicAuthenticationBehavior(user, password);
    }

    public static OClientBehavior azureTables(String account, String key) {
        return new AzureTableBehavior(account, key);
    }

    public static OClientBehavior methodTunneling(String ... methodsToTunnel) {
        return new MethodTunnelingBehavior(methodsToTunnel);
    }

    public static OClientBehavior rateLimit(final long millis) {
        return new OClientBehavior(){

            @Override
            public ODataClientRequest transform(ODataClientRequest request) {
                try {
                    Thread.sleep(millis);
                }
                catch (InterruptedException e) {
                    throw Throwables.propagate(e);
                }
                return request;
            }
        };
    }
}

