package org.hibernate.plugins.guards;

/**
 * @author vdedik@redhat.com
 */
public class H2Guard extends AbstractGuard {

    @Override
    public String safeGuardCreateTable(String sql) {
        return decorateWithIfNot("create table", sql);
    }

    @Override
    public String safeGuardDropTable(String sql) {
        return decorateWithIf("drop table", sql);
    }

    @Override
    public String safeGuardCreateSequence(String sql) {
        return decorateWithIfNot("create sequence", sql);
    }

    @Override
    public String safeGuardDropSequence(String sql) {
        return decorateWithIf("drop sequence", sql);
    }

    @Override
    public String safeGuardAlterTable(String sql) {
        return decorateWithExecuteIf(sql);
    }
}
