package com.redhat.installer.postinstall;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;

/**
 * Appends text onto the end of a given file. the text appended is contained
 * within the ProcessPanel.spec.xml. If no --text is supplied, every argument from args[1] onward is considered 
 * a line of text that will be appended onto the file in succession.
 * 
 * @author thauser
 * 
 */
public class TextFileAppender {
	private static final String FILE = "file";
	private static final String TEXT = "text";

	private static AutomatedInstallData idata;
	private static AbstractUIProcessHandler mHandler;

	public static void run(AbstractUIProcessHandler handler, String[] args) throws Exception {
		idata = AutomatedInstallData.getInstance();
		mHandler = handler;
		ArgumentParser parser = new ArgumentParser();
		parser.parse(args);
		File appendTarget = new File(parser.getProperty(FILE));
		PrintWriter pw = new PrintWriter(new FileWriter(appendTarget, true));
		if (parser.hasProperty(TEXT)){
			pw.println();
			pw.println(parser.getProperty(TEXT));
		}
		else {
			for (int i = 1; i < args.length; i++){
				pw.println(args[i]);
			}
		}
		pw.close();
	}
}
