Introduction
============
This quickstart demonstrates usage of custom ProcessorFactory used by Camel Exchange Bus internally to create and it's binding feature, by invoking given SQL query.

Running the quickstart
======================

JBoss AS 7
----------
1. Build the quickstart:

        mvn clean install

2. Start JBoss AS 7 in standalone-full mode:

        ${AS}/bin/standalone.sh --server-config=standalone-full.xml

3. Deploy the quickstart

        mvn jboss-as:deploy

4. Wait until quickstart is deployed
5. Launch SOAP UI (or any other web service client) and use wsdl generated by quickstart:

        http://localhost:8080/quickstart-cdi-bus/OrderService?wsdl

6. Provide dummy data and call web service. First call should return order with status

        Order Accepted

Second call should take a bit more and return order with status

        Order Accepted, after delay

7. In console you should see following output  
```
    [SimpleAuditor] Step DOMAIN_HANDLERS took 0ms  
    [SimpleAuditor] Step ADDRESSING took 0ms  
    [SimpleAuditor] Step TRANSACTION_HANDLER took 0ms  
    [SimpleAuditor] Step GENERIC_POLICY took 0ms  
    [SimpleAuditor] Step VALIDATION took 0ms  
    [SimpleAuditor] Step TRANSFORMATION took 0ms  
    [SimpleAuditor] Step VALIDATION took 0ms  
    [SelectiveAuditor] Calling provider with message Order[orderId=null, itemId=null, quantity=0]  
    [SimpleAuditor] Step PROVIDER_CALLBACK took 1001ms  
    [SelectiveAuditor] Provider respond with message OrderAck [orderId=null, accepted=true, status=Order Accepted, after delay]  
    [SimpleAuditor] Step TRANSACTION_HANDLER took 0ms  
    [SimpleAuditor] Step DOMAIN_HANDLERS took 0ms  
    [SimpleAuditor] Step VALIDATION took 0ms  
    [SimpleAuditor] Step TRANSFORMATION took 0ms  
    [SimpleAuditor] Step VALIDATION took 0ms  
    [SimpleAuditor] Step CONSUMER_CALLBACK took 1ms  
    [CountingProcessor] Route node filter[simple{${property.SwitchYardExchange.contract.consumerOperation.exchangePattern} == 'IN_OUT'}] took 14 ms
```
